/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.js_export.ExportAsType;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public class CounterSet<E>
implements Serializable,
Iterable<Pair<E, Integer>> {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="map")
    protected final @ExportAsType(value="Record<string, number>") Map<E, Integer> map = new LinkedHashMap<E, Integer>();
    @JsonProperty(value="total")
    protected int total = 0;

    public CounterSet() {
    }

    public CounterSet(Collection<E> keys) {
        this.incAll(keys);
    }

    public CounterSet(E key, int value) {
        this.inc(key, value);
    }

    public int inc(E key, int increment) {
        Integer value = this.map.get(key);
        int newValue = value == null ? increment : value + increment;
        this.map.put(key, newValue);
        this.total += increment;
        return this.getValue(key);
    }

    public int inc(E key) {
        return this.inc(key, 1);
    }

    public void incAll(Collection<E> keys, int increment) {
        for (E key : keys) {
            this.inc(key, increment);
        }
    }

    public void incAll(Collection<E> keys) {
        for (E key : keys) {
            this.inc(key);
        }
    }

    public void add(CounterSet<E> other) {
        for (Object key : other.getKeys()) {
            this.inc(key, other.getValue(key));
        }
    }

    public static <E> CounterSet<E> removeSecondFromFirst(CounterSet<E> first, CounterSet<E> second) {
        CounterSet<E> merged = new CounterSet<E>();
        for (E key : CollectionUtils.unionSet(first.getKeys(), second.getKeys())) {
            merged.inc(key, first.getValue(key));
            merged.inc(key, -second.getValue(key));
            if (merged.getValue(key) != 0) continue;
            merged.remove(key);
        }
        return merged;
    }

    public void removeIf(BiFunction<E, Integer, Boolean> filter) {
        this.map.entrySet().removeIf((? super E next) -> (Boolean)filter.apply((Object)next.getKey(), (Integer)next.getValue()));
    }

    public void remove(E key) {
        this.total -= this.getValue(key);
        this.map.remove(key);
    }

    public void removeAll(Collection<E> keys) {
        for (E key : keys) {
            this.remove(key);
        }
    }

    public void clear() {
        this.map.clear();
        this.total = 0;
    }

    public boolean contains(E key) {
        return this.map.containsKey(key);
    }

    public int getValue(E key) {
        Integer value = this.map.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public UnmodifiableSet<E> getKeys() {
        return CollectionUtils.asUnmodifiable(this.map.keySet());
    }

    public List<E> getKeysByValueAscending() {
        return CollectionUtils.sort(this.getKeys(), new Comparator<E>(){

            @Override
            public int compare(E key1, E key2) {
                return CounterSet.this.map.get(key1).compareTo(CounterSet.this.map.get(key2));
            }
        });
    }

    public List<E> getKeysByValueDescending() {
        return CollectionUtils.reverse(this.getKeysByValueAscending());
    }

    public int getTotal() {
        return this.total;
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public Collection<Integer> values() {
        return this.map.values();
    }

    public String toString() {
        return this.map.toString();
    }

    public void printValueDistribution(boolean ascending) {
        this.printValueDistribution(new PrintWriter(System.out), ascending);
    }

    public void printValueDistribution(PrintWriter writer, boolean ascending) {
        List<E> keys = null;
        keys = ascending ? this.getKeysByValueAscending() : this.getKeysByValueDescending();
        for (E key : keys) {
            writer.print(String.valueOf(key));
            writer.print(" : ");
            writer.print(this.getValue(key));
            writer.println();
        }
        writer.flush();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CounterSet) {
            CounterSet other = (CounterSet)obj;
            return this.map.equals(other.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public Map<E, Integer> toMap() {
        return new LinkedHashMap<E, Integer>(this.map);
    }

    public Map<E, Integer> toMapWithoutZeroEntries() {
        Map map = this.toMap();
        map.keySet().removeIf((? super E key) -> (Integer)map.get(key) == 0);
        return map;
    }

    @Override
    public Iterator<Pair<E, Integer>> iterator() {
        return new Iterator<Pair<E, Integer>>(){
            private Iterator<Map.Entry<E, Integer>> delegate;
            {
                this.delegate = CounterSet.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Pair<E, Integer> next() {
                Map.Entry next = this.delegate.next();
                if (next == null) {
                    return null;
                }
                return new Pair(next.getKey(), next.getValue());
            }
        };
    }
}

