/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class HybridMapBase<K, V>
implements Map<K, V> {
    private Map<K, V> map;

    protected HybridMapBase(Map<K, V> initialMap) {
        CCSMAssert.isNotNull(initialMap);
        this.map = initialMap;
    }

    protected abstract boolean shouldSwitch(Map<K, V> var1);

    protected abstract Map<K, V> obtainNewMap();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        if (this.shouldSwitch(this.map)) {
            Map<K, V> oldMap = this.map;
            this.map = this.obtainNewMap();
            this.map.putAll(oldMap);
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    public String toString() {
        return this.map.toString();
    }
}

