/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.Pair;

public class ListMap<K, V>
extends CollectionMap<K, V, List<V>> {
    private static final long serialVersionUID = 1L;

    public ListMap() {
    }

    public ListMap(ListMap<K, V> other) {
        this();
        this.addAll(other);
    }

    public boolean addIfNotNull(K key, V value) {
        if (key != null && value != null) {
            return this.add(key, value);
        }
        return true;
    }

    public static ListMap<String, String> of(String ... keysAndValues) {
        CCSMAssert.isTrue(keysAndValues.length % 2 == 0, "Expecting even number of arguments.");
        ListMap<String, String> listMap = new ListMap<String, String>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            listMap.add(keysAndValues[i], keysAndValues[i + 1]);
        }
        return listMap;
    }

    public static ListMap<String, String> fromNonEmptyPairs(Pair<?, ?> ... keysAndValuePairs) {
        ListMap<String, String> map = new ListMap<String, String>();
        Arrays.stream(keysAndValuePairs).filter(Objects::nonNull).filter(opt -> opt.getFirst() != null).filter(opt -> opt.getSecond() != null).forEach(opt -> map.add(opt.getFirst().toString(), opt.getSecond().toString()));
        return map;
    }

    public static <K, V> ListMap<K, V> of(K key, Collection<? extends V> values) {
        ListMap<K, ? extends V> listMap = new ListMap<K, V>();
        listMap.addAll(key, values);
        return listMap;
    }

    public static <K, V> ListMap<K, V> emptyMap() {
        return new ListMap<K, V>();
    }

    @Override
    protected List<V> createNewCollection() {
        return new ArrayList();
    }
}

