/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PairList<S, T>
implements Serializable,
Iterable<Pair<S, T>> {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="size")
    private int size = 0;
    @JsonProperty(value="firstElements")
    private Object[] firstElements;
    @JsonProperty(value="secondElements")
    private Object[] secondElements;
    private static final PairList EMPTY_PAIR_LIST = new PairList<Object, Object>(Collections.emptyMap()){
        private static final long serialVersionUID = 1L;

        @Override
        public Iterator<Pair<Object, Object>> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Spliterator<Pair<Object, Object>> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        public void add(Object first, Object second) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(PairList<Object, Object> other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Object> extractFirstList() {
            return Collections.emptyList();
        }

        @Override
        public List<Object> extractSecondList() {
            return Collections.emptyList();
        }
    };

    public PairList() {
        this(16);
    }

    public PairList(int initialCapacity) {
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.firstElements = new Object[initialCapacity];
        this.secondElements = new Object[initialCapacity];
    }

    public PairList(PairList<S, T> other) {
        this(other.size);
        this.addAll(other);
    }

    public PairList(Map<S, T> map) {
        this(map.size());
        for (Map.Entry<S, T> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public static <S, T> PairList<S, T> from(S key, T value) {
        PairList<S, T> result = new PairList<S, T>(1);
        result.add(key, value);
        return result;
    }

    @SafeVarargs
    public static <S, T> PairList<S, T> fromPairs(Pair<S, T> pair, Pair<S, T> ... additionalPairs) {
        PairList result = new PairList(1 + additionalPairs.length);
        result.add(pair.getFirst(), pair.getSecond());
        for (Pair<S, T> additionalPair : additionalPairs) {
            result.add(additionalPair.getFirst(), additionalPair.getSecond());
        }
        return result;
    }

    public static <S, T> PairList<S, T> fromMap(Map<S, T> map) {
        PairList<S, T> pairList = new PairList<S, T>(map.size());
        map.forEach(pairList::add);
        return pairList;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void add(S first, T second) {
        this.ensureSpace(this.size + 1);
        this.firstElements[this.size] = first;
        this.secondElements[this.size] = second;
        ++this.size;
    }

    public void insert(int index, S first, T second) {
        this.ensureSpace(this.size + 1);
        for (int i = this.size; i > index; --i) {
            this.firstElements[i] = this.firstElements[i - 1];
            this.secondElements[i] = this.secondElements[i - 1];
        }
        ++this.size;
        this.firstElements[index] = first;
        this.secondElements[index] = second;
    }

    public void addAll(PairList<S, T> other) {
        int otherSize = other.size;
        this.ensureSpace(this.size + otherSize);
        for (int i = 0; i < otherSize; ++i) {
            this.firstElements[this.size] = other.firstElements[i];
            this.secondElements[this.size] = other.secondElements[i];
            ++this.size;
        }
    }

    private void ensureSpace(int space) {
        int newSize;
        if (space <= this.firstElements.length) {
            return;
        }
        Object[] oldFirst = this.firstElements;
        Object[] oldSecond = this.secondElements;
        for (newSize = this.firstElements.length * 2; newSize < space; newSize *= 2) {
        }
        this.firstElements = new Object[newSize];
        this.secondElements = new Object[newSize];
        System.arraycopy(oldFirst, 0, this.firstElements, 0, this.size);
        System.arraycopy(oldSecond, 0, this.secondElements, 0, this.size);
    }

    public S getFirst(int i) {
        this.checkWithinBounds(i);
        return (S)this.firstElements[i];
    }

    private void checkWithinBounds(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException("Out of bounds: " + i);
        }
    }

    public void setFirst(int i, S value) {
        this.checkWithinBounds(i);
        this.firstElements[i] = value;
    }

    public T getSecond(int i) {
        this.checkWithinBounds(i);
        return (T)this.secondElements[i];
    }

    public void setSecond(int i, T value) {
        this.checkWithinBounds(i);
        this.secondElements[i] = value;
    }

    public List<S> extractFirstList() {
        ArrayList<Object> result = new ArrayList<Object>(this.size + 1);
        for (int i = 0; i < this.size; ++i) {
            result.add(this.firstElements[i]);
        }
        return result;
    }

    public UnmodifiableList<S> getFirstList() {
        return CollectionUtils.asUnmodifiable(Arrays.asList(this.firstElements).subList(0, this.size));
    }

    public List<T> extractSecondList() {
        return this.extractSecondElementsFilteredByFirst(x -> true);
    }

    public UnmodifiableList<T> getSecondList() {
        return CollectionUtils.asUnmodifiable(Arrays.asList(this.secondElements).subList(0, this.size));
    }

    public List<T> extractSecondElementsFilteredByFirst(Predicate<S> predicate) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.firstElements[i])) continue;
            result.add(this.secondElements[i]);
        }
        return result;
    }

    public void swapEntries(int i, int j) {
        S tmp1 = this.getFirst(i);
        T tmp2 = this.getSecond(i);
        this.setFirst(i, this.getFirst(j));
        this.setSecond(i, this.getSecond(j));
        this.setFirst(j, tmp1);
        this.setSecond(j, tmp2);
    }

    public void clear() {
        this.size = 0;
    }

    public void removeLast() {
        CCSMAssert.isTrue(this.size > 0, "Size must be positive!");
        --this.size;
        this.firstElements[this.size] = null;
        this.secondElements[this.size] = null;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.firstElements[i - 1] = this.firstElements[i];
            this.secondElements[i - 1] = this.secondElements[i];
        }
        this.removeLast();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append('(');
            result.append(this.firstElements[i]);
            result.append(',');
            result.append(this.secondElements[i]);
            result.append(')');
        }
        result.append(']');
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hash = this.size;
        hash = prime * hash + PairList.hashArrayUntil(this.firstElements, this.size);
        return prime * hash + PairList.hashArrayUntil(this.secondElements, this.size);
    }

    private static int hashArrayUntil(Object[] objects, int endExclusive) {
        int hashCode = 1;
        for (int i = 0; i < endExclusive; ++i) {
            hashCode = hashCode * 31 + Objects.hashCode(objects[i]);
        }
        return hashCode;
    }

    private static boolean arrayEqualsUntil(Object[] elements, Object[] otherElements, int endExclusive) {
        for (int i = 0; i < endExclusive; ++i) {
            if (Objects.equals(elements[i], otherElements[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PairList)) {
            return false;
        }
        PairList other = (PairList)obj;
        if (this.size != other.size) {
            return false;
        }
        return PairList.arrayEqualsUntil(this.firstElements, other.firstElements, this.size) && PairList.arrayEqualsUntil(this.secondElements, other.secondElements, this.size);
    }

    @Override
    public Iterator<Pair<S, T>> iterator() {
        return new Iterator<Pair<S, T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < PairList.this.size;
            }

            @Override
            public Pair<S, T> next() {
                PairList.this.checkWithinBounds(this.index);
                int oldIndex = this.index++;
                return PairList.this.createPairForIndex(oldIndex);
            }
        };
    }

    public Stream<Pair<S, T>> stream() {
        return StreamSupport.stream(new PairListSpliterator(), false);
    }

    public Map<S, T> toMap() {
        HashMap result = new HashMap();
        this.forEach(result::put);
        return result;
    }

    public Map<S, T> toMap(BinaryOperator<T> mergeFunction) {
        return this.stream().collect(Collectors.toMap(ImmutablePair::getFirst, ImmutablePair::getSecond, mergeFunction));
    }

    private Pair<S, T> createPairForIndex(int index) {
        return new Pair<Object, Object>(this.firstElements[index], this.secondElements[index]);
    }

    public static <S, T> PairListCollector<S, T> toPairList() {
        return new PairListCollector();
    }

    public static <S, T> PairList<S, T> zip(List<S> firstValues, List<T> secondValues) {
        CCSMAssert.isTrue(firstValues.size() == secondValues.size(), "Can only zip together collections of the same size.");
        PairList<S, T> result = new PairList<S, T>(firstValues.size());
        Iterator<S> firstIterator = firstValues.iterator();
        Iterator<T> secondIterator = secondValues.iterator();
        while (firstIterator.hasNext()) {
            result.add(firstIterator.next(), secondIterator.next());
        }
        return result;
    }

    public void forEach(BiConsumer<S, T> consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.getFirst(i), this.getSecond(i));
        }
    }

    public <S2, T2> PairList<S2, T2> map(BiFunction<S, T, S2> firstMapper, BiFunction<S, T, T2> secondMapper) {
        PairList result = new PairList(this.size);
        this.forEach((S key, T value) -> result.add(firstMapper.apply(key, value), secondMapper.apply(key, value)));
        return result;
    }

    public <U, E extends Exception> PairList<U, T> mapFirst(CollectionUtils.FunctionWithException<S, U, ? extends E> mapper) throws E {
        PairList<U, T> mappedList = new PairList<U, T>(this.size);
        for (int i = 0; i < this.size; ++i) {
            mappedList.add(mapper.apply(this.getFirst(i)), this.getSecond(i));
        }
        return mappedList;
    }

    public <U, E extends Exception> PairList<S, U> mapSecond(CollectionUtils.FunctionWithException<T, U, ? extends E> mapper) throws E {
        PairList<S, U> mappedList = new PairList<S, U>(this.size);
        for (int i = 0; i < this.size; ++i) {
            mappedList.add(this.getFirst(i), mapper.apply(this.getSecond(i)));
        }
        return mappedList;
    }

    public PairList<S, T> filter(BiFunction<S, T, Boolean> filterPredicate) {
        PairList<S, T> filteredList = new PairList<S, T>(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (!filterPredicate.apply(this.getFirst(i), this.getSecond(i)).booleanValue()) continue;
            filteredList.add(this.getFirst(i), this.getSecond(i));
        }
        return filteredList;
    }

    public boolean anyMatch(BiFunction<S, T, Boolean> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.apply(this.getFirst(i), this.getSecond(i)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public PairList<S, T> reverse() {
        PairList<S, T> reversed = new PairList<S, T>(this.size());
        for (int i = this.size() - 1; i >= 0; --i) {
            reversed.add(this.getFirst(i), this.getSecond(i));
        }
        return reversed;
    }

    public PairList<T, S> inverse() {
        PairList<T, S> inverse = new PairList<T, S>(this.size());
        for (int i = this.size() - 1; i >= 0; --i) {
            inverse.add(this.getSecond(i), this.getFirst(i));
        }
        return inverse;
    }

    public Pair<S, T>[] toArray() {
        Pair[] result = new Pair[this.size];
        for (int i = 0; i < this.size; ++i) {
            result[i] = new Pair<Object, Object>(this.firstElements[i], this.secondElements[i]);
        }
        return result;
    }

    public List<Pair<S, T>> toList() {
        return this.toList(Pair::new);
    }

    public <R> List<R> toList(BiFunction<S, T, R> entryFactory) {
        ArrayList<R> result = new ArrayList<R>(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.add(entryFactory.apply(this.firstElements[i], this.secondElements[i]));
        }
        return result;
    }

    public void sort(Comparator<Pair<S, T>> comparator) {
        Pair<S, T>[] sorted = this.toArray();
        Arrays.sort(sorted, comparator);
        for (int i = 0; i < sorted.length; ++i) {
            this.setFirst(i, sorted[i].getFirst());
            this.setSecond(i, sorted[i].getSecond());
        }
    }

    public static <S, T> PairList<S, T> concatenate(PairList<S, T> list1, PairList<S, T> list2) {
        PairList<S, T> result = new PairList<S, T>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    public static <S, T> PairList<S, T> emptyPairList() {
        return EMPTY_PAIR_LIST;
    }

    public void addIfPresent(Optional<Pair<S, T>> pair) {
        if (pair.isPresent()) {
            this.add(pair.get().getFirst(), pair.get().getSecond());
        }
    }

    public <S2, T2> PairList<S2, T2> map(Function<S, S2> keyMapper, Function<T, T2> valueMapper) {
        PairList result = new PairList();
        this.forEach((S key, T value) -> result.add(keyMapper.apply(key), valueMapper.apply(value)));
        return result;
    }

    public <S2, T2, E extends Exception> PairList<S2, T2> mapWithException(CollectionUtils.FunctionWithException<S, S2, ? extends E> keyMapper, CollectionUtils.FunctionWithException<T, T2, ? extends E> valueMapper) throws E {
        PairList<S2, T2> result = new PairList<S2, T2>();
        for (Pair<S, T> pair : this) {
            result.add(keyMapper.apply(pair.getFirst()), valueMapper.apply(pair.getSecond()));
        }
        return result;
    }

    public Optional<Integer> indexOfFirst(S firstSearchObject) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.firstElements[i], firstSearchObject)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    int capacity() {
        return this.firstElements.length;
    }

    private static class PairListCollector<S, T>
    implements Collector<Pair<S, T>, PairList<S, T>, PairList<S, T>> {
        private PairListCollector() {
        }

        @Override
        public Supplier<PairList<S, T>> supplier() {
            return PairList::new;
        }

        @Override
        public BiConsumer<PairList<S, T>, Pair<S, T>> accumulator() {
            return (list, pair) -> list.add(pair.getFirst(), pair.getSecond());
        }

        @Override
        public BinaryOperator<PairList<S, T>> combiner() {
            return (list1, list2) -> {
                list1.addAll(list2);
                return list1;
            };
        }

        @Override
        public Function<PairList<S, T>, PairList<S, T>> finisher() {
            return list -> list;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
        }
    }

    private final class PairListSpliterator
    implements Spliterator<Pair<S, T>> {
        @JsonProperty(value="nextElementToProcess")
        private int nextElementToProcess;

        private PairListSpliterator() {
        }

        @Override
        public int characteristics() {
            return 1104;
        }

        @Override
        public long estimateSize() {
            return PairList.this.size - this.nextElementToProcess;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Pair<S, T>> action) {
            if (this.nextElementToProcess == PairList.this.size) {
                return false;
            }
            action.accept(PairList.this.createPairForIndex(this.nextElementToProcess));
            ++this.nextElementToProcess;
            return true;
        }

        @Override
        public Spliterator<Pair<S, T>> trySplit() {
            return null;
        }
    }
}

