/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class TwoDimHashMap<K1, K2, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K1, Map<K2, V>> data;

    public TwoDimHashMap() {
        this.data = new HashMap<K1, Map<K2, V>>();
    }

    public TwoDimHashMap(Map<K1, Map<K2, V>> map) {
        this.data = map;
    }

    public void putAll(TwoDimHashMap<K1, K2, V> otherMap) {
        for (K1 key1 : otherMap.getFirstKeys()) {
            for (K2 key2 : otherMap.getSecondKeys(key1)) {
                V value = otherMap.getValue(key1, key2);
                this.putValue(key1, key2, value);
            }
        }
    }

    public void putValue(K1 key1, K2 key2, V value) {
        Map map = this.data.computeIfAbsent(key1, ignored -> new HashMap());
        map.put(key2, value);
    }

    public V getValue(K1 firstKey, K2 secondKey) {
        Map<K2, V> map = this.data.get(firstKey);
        if (map == null) {
            return null;
        }
        return map.get(secondKey);
    }

    public V getValueOrDefault(K1 firstKey, K2 secondKey, V defaultValue) {
        V value = this.getValue(firstKey, secondKey);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean containsKey(K1 firstKey, K2 secondKey) {
        Map<K2, V> map = this.data.get(firstKey);
        if (map == null) {
            return false;
        }
        return map.containsKey(secondKey);
    }

    public Collection<V> getValuesByFirstKey(K1 firstKey) {
        Map<K2, V> map = this.data.get(firstKey);
        if (map == null) {
            return null;
        }
        return map.values();
    }

    public Set<K1> getFirstKeys() {
        return this.data.keySet();
    }

    public Set<K2> getSecondKeys(K1 firstKey) {
        Map<K2, V> map = this.data.get(firstKey);
        if (map == null) {
            return CollectionUtils.emptySet();
        }
        return map.keySet();
    }

    public List<V> getValuesBySecondKey(K2 secondKey) {
        ArrayList<V> result = new ArrayList<V>();
        for (Map<K2, V> map : this.data.values()) {
            if (!map.containsKey(secondKey)) continue;
            result.add(map.get(secondKey));
        }
        return result;
    }

    public List<V> getValues() {
        ArrayList<V> result = new ArrayList<V>();
        for (Map<K2, V> map : this.data.values()) {
            result.addAll(map.values());
        }
        return result;
    }

    public int getSize() {
        int size = 0;
        for (Map<K2, V> map : this.data.values()) {
            size += map.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSecondSize(K1 key1) {
        Map<K2, V> map = this.data.get(key1);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public void clear() {
        this.data.clear();
    }

    public V remove(K1 key1, K2 key2) {
        Map<K2, V> map = this.data.get(key1);
        if (map == null) {
            return null;
        }
        if (!map.containsKey(key2)) {
            return null;
        }
        V result = map.remove(key2);
        if (map.isEmpty()) {
            this.data.remove(key1);
        }
        return result;
    }

    public boolean remove(K1 key) {
        Map<K2, V> result = this.data.remove(key);
        return result != null;
    }

    public UnmodifiableMap<K2, V> getSecondMap(K1 key) {
        Map<K2, V> secondMap = this.data.get(key);
        if (secondMap == null) {
            return null;
        }
        return CollectionUtils.asUnmodifiable(secondMap);
    }
}

