/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.color;

import java.awt.Color;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.color.ECCSMColor;
import org.conqat.lib.commons.enums.EnumUtils;

public class ColorUtils {
    public static Pattern HTML_COLOR_PATTERN = Pattern.compile("#[0-9a-f]{6}", 2);

    public static String toHtmlString(Color color) {
        return String.format("#%06X", color.getRGB() & 0xFFFFFF);
    }

    public static Color fromString(String s) {
        Enum color;
        if (HTML_COLOR_PATTERN.matcher(s).matches()) {
            return Color.decode("0x" + s.substring(1));
        }
        if (s.startsWith("ccsm-") && (color = EnumUtils.valueOfIgnoreCase(ECCSMColor.class, s.substring(5))) != null) {
            return ((ECCSMColor)color).getColor();
        }
        color = EnumUtils.valueOfIgnoreCase(EAWTColors.class, s);
        if (color != null) {
            return ((EAWTColors)color).getColor();
        }
        return null;
    }

    public static Color blend(double factor, Color color1, Color color2) {
        CCSMAssert.isTrue(factor >= 0.0 && factor <= 1.0, "Factor must be between 0 and 1 but is: " + factor);
        int r = ColorUtils.getColorComponent(factor, color1, color2, Color::getRed);
        int g = ColorUtils.getColorComponent(factor, color1, color2, Color::getGreen);
        int b = ColorUtils.getColorComponent(factor, color1, color2, Color::getBlue);
        return new Color(r, g, b);
    }

    protected static int getColorComponent(double factor, Color color1, Color color2, Function<Color, Integer> function) {
        return (int)Math.round(factor * (double)function.apply(color1).intValue() + (1.0 - factor) * (double)function.apply(color2).intValue());
    }

    private static enum EAWTColors {
        RED(Color.RED),
        GREEN(Color.GREEN),
        BLUE(Color.BLUE),
        YELLOW(Color.YELLOW),
        ORANGE(Color.ORANGE),
        WHITE(Color.WHITE),
        BLACK(Color.BLACK),
        GRAY(Color.GRAY),
        CYAN(Color.CYAN),
        MAGENTA(Color.MAGENTA);

        private final Color color;

        private EAWTColors(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

