/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.color;

import java.awt.Color;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;

public class MultiColor
extends Color {
    private static final long serialVersionUID = 1L;
    private final PairList<Color, Integer> colorDistribution;
    private final int sum;

    public MultiColor(Color primaryColor, PairList<Color, Integer> colorDistribution) {
        super(primaryColor.getRed(), primaryColor.getGreen(), primaryColor.getBlue(), primaryColor.getAlpha());
        this.sum = MultiColor.checkAndAddDistribution(colorDistribution);
        this.colorDistribution = new PairList<Color, Integer>(colorDistribution);
    }

    private static int checkAndAddDistribution(PairList<Color, Integer> colorDistribution) throws AssertionError {
        CCSMAssert.isTrue(!colorDistribution.isEmpty(), "Distribution may not be empty.");
        int sum = 0;
        for (int i = 0; i < colorDistribution.size(); ++i) {
            CCSMAssert.isNotNull(colorDistribution.getFirst(i));
            CCSMAssert.isTrue(colorDistribution.getSecond(i) > 0, "Color entry must be positive!");
            sum += colorDistribution.getSecond(i).intValue();
        }
        return sum;
    }

    public int size() {
        return this.colorDistribution.size();
    }

    public Color getColor(int index) {
        return this.colorDistribution.getFirst(index);
    }

    public int getFrequency(int index) {
        return this.colorDistribution.getSecond(index);
    }

    public double getRelativeFrequency(int index) {
        return (double)this.colorDistribution.getSecond(index).intValue() / (double)this.sum;
    }
}

