/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.color.IColorProvider;

public class RandomColorProvider<T>
implements IColorProvider<T> {
    private final Map<Object, Color> cache = new HashMap<Object, Color>();

    @Override
    public Color getColor(T t) {
        Object key = this.getKey(t);
        Color c = this.cache.get(key);
        if (c == null) {
            c = this.generateColor();
            this.cache.put(key, c);
        }
        return c;
    }

    protected Color generateColor() {
        int i = this.cache.size();
        int fractions = 3;
        boolean bright = true;
        float hue = 0.0f;
        if (i < 2 * fractions) {
            hue = (float)(i % fractions) / (float)fractions;
            if (i >= fractions) {
                bright = false;
            }
        } else {
            i -= 6;
            while (i >= fractions) {
                bright = false;
                if ((i -= fractions) < fractions) continue;
                bright = true;
                fractions *= 2;
            }
            hue = 0.5f / (float)fractions * (float)(2 * i + 1);
        }
        if (bright) {
            return new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f));
        }
        return new Color(Color.HSBtoRGB(hue, 1.0f, 0.7f));
    }

    protected Object getKey(T t) {
        return t;
    }
}

