/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.datamining.AssociationRule;
import org.conqat.lib.commons.datamining.AssociationRuleMiner;
import org.conqat.lib.commons.datamining.IRecommender;
import org.conqat.lib.commons.datamining.IRecommenderUser;
import org.conqat.lib.commons.datamining.Recommendation;
import org.conqat.lib.commons.datamining.RecommenderRatingDatabase;

public class AssociationRuleRecommender<T>
implements IRecommender<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RecommenderRatingDatabase<T> ratingDatabase;
    private final Set<AssociationRule<T>> associationRules;

    public AssociationRuleRecommender(RecommenderRatingDatabase<T> ratingDatabase, float supportThreshold, float confidenceThreshold) {
        this.ratingDatabase = ratingDatabase;
        HashSet baskets = new HashSet();
        for (IRecommenderUser user : ratingDatabase.getUsers()) {
            baskets.add(ratingDatabase.getLikedItems(user));
        }
        this.associationRules = new AssociationRuleMiner(supportThreshold, confidenceThreshold).mineAssociationRules(baskets);
    }

    @Override
    public Set<Recommendation<T>> recommend(IRecommenderUser user) {
        HashMap<T, Recommendation<T>> itemToRecommendationMap = new HashMap<T, Recommendation<T>>();
        Set<T> items = this.ratingDatabase.getLikedItems(user);
        for (AssociationRule<T> rule : this.associationRules) {
            if (!items.containsAll(rule.getItemSet()) || items.contains(rule.getAssociatedItem())) continue;
            T item = rule.getAssociatedItem();
            double confidence = rule.getConfidence();
            Recommendation existingRecommendation = (Recommendation)itemToRecommendationMap.get(item);
            if (existingRecommendation != null && !(confidence > existingRecommendation.getConfidence())) continue;
            itemToRecommendationMap.put(item, new Recommendation<T>(item, confidence));
        }
        return new HashSet<Recommendation<T>>(itemToRecommendationMap.values());
    }
}

