/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.datamining;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SparseVector {
    private Map<Integer, Double> data = new HashMap<Integer, Double>();

    public void set(int key, double value) {
        this.data.put(key, value);
    }

    public double cosineSimilarity(SparseVector other) {
        double dotProduct = 0.0;
        HashSet<Integer> commonPositions = CollectionUtils.intersectionSet(this.data.keySet(), other.data.keySet());
        for (Integer commonPosition : commonPositions) {
            dotProduct += this.data.get(commonPosition) * other.data.get(commonPosition);
        }
        double divisor = this.l2norm() * other.l2norm();
        if (divisor == 0.0) {
            return 0.0;
        }
        return dotProduct / divisor;
    }

    private double l2norm() {
        double tmp = 0.0;
        for (Integer position : this.data.keySet()) {
            tmp += Math.pow(this.data.get(position), 2.0);
        }
        return Math.sqrt(tmp);
    }
}

