/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.date;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import org.conqat.lib.commons.date.DateTimeUtils;

public class DurationUtils {
    public static final int NANOS_PER_MICRO = 1000;
    public static final int MICROS_PER_MILLI = 1000;
    public static final int NANOS_PER_MILLI = 1000000;
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MICROS_PER_SECOND = 1000000;
    public static final int NANOS_PER_SECOND = 1000000000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MICROS_PER_MINUTE = 60000000;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final long MICROS_PER_HOUR = 3600000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    public static final int HOURS_PER_DAY = 24;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int MILLIS_PER_DAY = 86400000;
    public static final long MICROS_PER_DAY = 86400000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;
    public static final int DAYS_PER_YEAR = 365;
    public static final int HOURS_PER_YEAR = 8760;
    public static final int MINUTES_PER_YEAR = 525600;
    public static final int SECONDS_PER_YEAR = 31536000;
    public static final long MILLIS_PER_YEAR = 31536000000L;
    public static final long MICROS_PER_YEAR = 31536000000000L;
    public static final long NANOS_PER_YEAR = 31536000000000000L;
    public static final Duration ONE_MILLISECOND = Duration.ofMillis(1L);
    public static final Duration ONE_SECOND = Duration.ofSeconds(1L);
    public static final Duration ONE_MINUTE = Duration.ofMinutes(1L);
    public static final Duration ONE_HOUR = Duration.ofHours(1L);
    public static final Period ONE_WEEK = Period.ofDays(7);
    public static final Period ONE_MONTH = Period.ofMonths(1);
    public static final Period ONE_YEAR = Period.ofYears(1);

    public static boolean elapsed(Duration duration, long sinceMillisTimestampUTC) {
        long requiredToElapse;
        long currentMillis = DateTimeUtils.getClock().millis();
        long elapsedSince = currentMillis - sinceMillisTimestampUTC;
        return elapsedSince > (requiredToElapse = duration.toMillis());
    }

    public static String formatDurationHumanReadable(Duration duration) {
        long milliseconds = duration.toMillis() % 1000L;
        long seconds = duration.toMillis() / 1000L % 60L;
        long minutes = duration.toMillis() / 60000L % 60L;
        long hours = duration.toMillis() / 3600000L;
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours).append("h ");
        }
        if (hours > 0L || minutes > 0L) {
            builder.append(minutes).append("min ");
        }
        if (hours > 0L || minutes > 0L || seconds > 0L) {
            builder.append(seconds).append("s ");
        }
        builder.append(milliseconds).append("ms");
        return builder.toString();
    }

    public static Duration toDuration(TemporalAmount temporalAmount) {
        if (temporalAmount instanceof Duration) {
            return (Duration)temporalAmount;
        }
        Duration result = Duration.ZERO;
        for (TemporalUnit unit : temporalAmount.getUnits()) {
            Duration baseDuration = unit.getDuration();
            long amount = temporalAmount.get(unit);
            result = result.plus(baseDuration.multipliedBy(amount));
        }
        return result;
    }
}

