/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class CanonicalFile
extends File {
    private static final long serialVersionUID = 1L;

    public CanonicalFile(File file) throws IOException {
        super(file.getCanonicalPath());
    }

    public CanonicalFile(String pathname) throws IOException {
        super(new File(pathname).getCanonicalPath());
    }

    public CanonicalFile(File parent, String child) throws IOException {
        this(new File(parent, child));
    }

    public CanonicalFile(String parent, String child) throws IOException {
        this(new File(parent, child));
    }

    public CanonicalFile(URI uri) throws IOException {
        super(new File(uri).getCanonicalPath());
    }

    @Override
    @Deprecated
    public CanonicalFile getAbsoluteFile() {
        return this;
    }

    @Override
    public CanonicalFile getCanonicalFile() {
        return this;
    }

    public CanonicalFile[] listFiles() {
        File[] files = super.listFiles();
        if (files == null) {
            return null;
        }
        return CanonicalFile.canonize(files);
    }

    public CanonicalFile[] listFiles(FileFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        CanonicalFile[] result = new CanonicalFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CanonicalFile.canonize(files[i].getAbsoluteFile());
        }
        return result;
    }

    public CanonicalFile[] listFiles(FilenameFilter filter) {
        File[] files = super.listFiles(filter);
        if (files == null) {
            return null;
        }
        return CanonicalFile.canonize(files);
    }

    @Override
    public CanonicalFile getParentFile() {
        File parent = super.getParentFile();
        if (parent == null) {
            return null;
        }
        return CanonicalFile.canonize(parent);
    }

    public boolean isReadableFile() {
        return this.isFile() && this.canRead();
    }

    @Override
    public String getCanonicalPath() {
        return super.getPath();
    }

    @Override
    @Deprecated
    public String getAbsolutePath() {
        return super.getPath();
    }

    @Override
    @Deprecated
    public String getPath() {
        return super.getPath();
    }

    public String getExtension() {
        return FileSystemUtils.getFileExtension(this);
    }

    private static CanonicalFile[] canonize(File[] files) {
        CanonicalFile[] result = new CanonicalFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CanonicalFile.canonize(files[i]);
        }
        return result;
    }

    private static CanonicalFile canonize(File file) {
        try {
            return new CanonicalFile(file);
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Problems creating canonical path for " + file + ": " + e.getMessage()));
        }
    }
}

