/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class MarkableFileInputStream
extends FilterInputStream {
    private final FileChannel channel;
    private long mark = -1L;

    public MarkableFileInputStream(FileInputStream fis) {
        super(fis);
        this.channel = fis.getChannel();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.channel.position();
        }
        catch (IOException ex) {
            this.mark = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("Must call mark() before reset()!");
        }
        this.channel.position(this.mark);
    }
}

