/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.graph;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.conqat.lib.commons.graph.EGraphvizOutputFormat;
import org.conqat.lib.commons.graph.GraphvizException;
import org.conqat.lib.commons.io.StreamReaderThread;

public class GraphvizGenerator {
    public static final String DOT_EXECUTABLE = "dot";

    public void generateFile(String description, File file, EGraphvizOutputFormat format) throws IOException, GraphvizException {
        this.runDot(description, null, "-T" + format.name().toLowerCase(), "-o" + file);
    }

    public String generateFileAndImageMap(String description, File file, EGraphvizOutputFormat format) throws IOException, GraphvizException {
        TextReader reader = new TextReader();
        this.runDot(description, reader, "-T" + format.name().toLowerCase(), "-o" + file, "-Tcmap");
        return reader.contents.toString();
    }

    public BufferedImage generateImage(String description) throws IOException, GraphvizException {
        ImageReader reader = new ImageReader();
        this.runDot(description, reader, "-Tpng");
        return reader.image;
    }

    private void runDot(String description, IStreamReader streamReader, String ... arguments) throws IOException, GraphvizException {
        String[] completeArguments = new String[arguments.length + 1];
        completeArguments[0] = DOT_EXECUTABLE;
        for (int i = 0; i < arguments.length; ++i) {
            completeArguments[i + 1] = arguments[i];
        }
        ProcessBuilder builder = new ProcessBuilder(completeArguments);
        Process dotProcess = builder.start();
        StreamReaderThread errReader = new StreamReaderThread(dotProcess.getErrorStream());
        OutputStreamWriter stdIn = new OutputStreamWriter(dotProcess.getOutputStream());
        stdIn.write(description);
        ((Writer)stdIn).close();
        if (streamReader == null) {
            new StreamReaderThread(dotProcess.getInputStream());
        } else {
            streamReader.performReading(dotProcess.getInputStream());
        }
        try {
            dotProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String errorContent = errReader.getContent();
        if (dotProcess.exitValue() != 0 || errorContent.contains("syntax error")) {
            throw new GraphvizException(errorContent);
        }
    }

    private static class TextReader
    implements IStreamReader {
        StringBuilder contents = new StringBuilder();

        private TextReader() {
        }

        @Override
        public void performReading(InputStream inputStream) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            char[] buffer = new char[1024];
            int read = 0;
            while ((read = reader.read(buffer)) != -1) {
                this.contents.append(buffer, 0, read);
            }
        }
    }

    private static class ImageReader
    implements IStreamReader {
        BufferedImage image = null;

        private ImageReader() {
        }

        @Override
        public void performReading(InputStream inputStream) throws IOException {
            this.image = ImageIO.read(inputStream);
        }
    }

    private static interface IStreamReader {
        public void performReading(InputStream var1) throws IOException;
    }
}

