/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.io.StreamReaderThread;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;

public class ProcessUtils {
    private static final Charset CONSOLE_CHARSET = ProcessUtils.determineConsoleCharset();
    public static final String MONO_COMMAND = "mono";
    public static final String DOTNET_COMMAND = "dotnet";

    private static Charset determineConsoleCharset() {
        if (SystemUtils.isWindows()) {
            try {
                ExecutionResult result = ProcessUtils.execute(new ProcessBuilder("chcp.com"), null, -1, true, StandardCharsets.UTF_8);
                Matcher matcher = Pattern.compile("\\d+").matcher(result.getStdout());
                if (matcher.find()) {
                    String charsetName = "Cp" + matcher.group();
                    return Charset.forName(charsetName);
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return StandardCharsets.UTF_8;
    }

    public static ProcessBuilder createDotNetProcessBuilder(String ... arguments) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (!SystemUtils.isWindows()) {
            builder.command().add(MONO_COMMAND);
        }
        builder.command().addAll(Arrays.asList(arguments));
        return builder;
    }

    public static ExecutionResult executeDotNet(String[] completeArguments) throws IOException {
        return ProcessUtils.execute(ProcessUtils.createDotNetProcessBuilder(completeArguments));
    }

    public static ExecutionResult execute(String[] completeArguments) throws IOException {
        return ProcessUtils.execute(completeArguments, null);
    }

    public static ExecutionResult execute(String[] completeArguments, String input) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(completeArguments);
        return ProcessUtils.execute(builder, input);
    }

    public static ExecutionResult execute(ProcessBuilder builder) throws IOException {
        return ProcessUtils.execute(builder, null);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input) throws IOException {
        return ProcessUtils.execute(builder, input, -1);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input, int timeout) throws IOException {
        return ProcessUtils.execute(builder, input, timeout, true);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input, int timeout, boolean collectOutputStreamContent) throws IOException {
        return ProcessUtils.execute(builder, input, timeout, collectOutputStreamContent, CONSOLE_CHARSET);
    }

    private static ExecutionResult execute(ProcessBuilder builder, String input, int timeout, boolean collectOutputStreamContent, Charset consoleCharset) throws IOException {
        Process process = builder.start();
        StreamReaderThread stderrReader = new StreamReaderThread(process.getErrorStream(), consoleCharset, collectOutputStreamContent);
        StreamReaderThread stdoutReader = new StreamReaderThread(process.getInputStream(), consoleCharset, collectOutputStreamContent);
        if (input != null) {
            OutputStreamWriter stdIn = new OutputStreamWriter(process.getOutputStream(), consoleCharset);
            stdIn.write(input);
            ((Writer)stdIn).close();
        }
        boolean normalTermination = ProcessUtils.waitForProcess(process, timeout);
        int exitValue = -1;
        if (normalTermination) {
            exitValue = process.exitValue();
        }
        try {
            stderrReader.join();
            stdoutReader.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new ExecutionResult(stdoutReader.getContent(), stderrReader.getContent(), exitValue, normalTermination);
    }

    private static boolean waitForProcess(Process process, int maxRuntimeSeconds) {
        boolean processFinished;
        try {
            long timeout = maxRuntimeSeconds;
            if (timeout <= 0L) {
                timeout = Long.MAX_VALUE;
            }
            processFinished = process.waitFor(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            processFinished = false;
        }
        if (!processFinished) {
            process.destroy();
        }
        return processFinished;
    }

    public static <T extends Exception> ExecutionResult executeOrThrow(ProcessBuilder builder, String input, int timeout, BiFunction<String, Throwable, T> exceptionConstructor) throws T {
        String commandString = StringUtils.concat(builder.command(), " ");
        try {
            ExecutionResult result = ProcessUtils.execute(builder, input, timeout);
            if (!result.isNormalTermination()) {
                throw (Exception)exceptionConstructor.apply("Process " + commandString + " timed out.", null);
            }
            if (result.getReturnCode() != 0) {
                throw (Exception)exceptionConstructor.apply("Process " + commandString + " failed with non-zero exit code " + result.getReturnCode() + ". Standard output: '" + result.getStdout() + "', Error output: '" + result.getStderr() + "'", null);
            }
            return result;
        }
        catch (IOException e) {
            throw (Exception)exceptionConstructor.apply("Failed to execute " + commandString, e);
        }
    }

    public static class ExecutionResult {
        private final String stdout;
        private final String stderr;
        private final int returnCode;
        private final boolean normalTermination;

        private ExecutionResult(String stdout, String stderr, int returnCode, boolean normalTermination) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.returnCode = returnCode;
            this.normalTermination = normalTermination;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public boolean isNormalTermination() {
            return this.normalTermination;
        }
    }
}

