/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class SelfDeletingTempDirectory
extends File
implements AutoCloseable {
    private static final long serialVersionUID = 1L;
    private final boolean keepUntilShutdown;

    public SelfDeletingTempDirectory(String prefix) throws IOException {
        this(prefix, false);
    }

    private SelfDeletingTempDirectory(String prefix, boolean keepUntilShutdown) throws IOException {
        super(Files.createTempDirectory(prefix, new FileAttribute[0]).toUri());
        this.keepUntilShutdown = keepUntilShutdown;
        if (keepUntilShutdown) {
            this.deleteOnShutdown();
        }
    }

    public static SelfDeletingTempDirectory createAndDeleteOnShutdown(String prefix) throws IOException {
        return new SelfDeletingTempDirectory(prefix, true);
    }

    @Override
    public void close() {
        if (this.keepUntilShutdown) {
            return;
        }
        FileSystemUtils.deleteRecursively(this);
        if (this.exists()) {
            this.deleteOnShutdown();
        }
    }

    private void deleteOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> FileSystemUtils.deleteRecursively(this)));
    }
}

