/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StreamReaderThread
extends Thread {
    private final InputStream input;
    private final StringBuilder content = new StringBuilder();
    private final boolean storeContent;
    private final Charset charset;
    private IOException exception;

    public StreamReaderThread(InputStream input) {
        this(input, StandardCharsets.UTF_8, true);
    }

    public StreamReaderThread(InputStream input, Charset charset) {
        this(input, charset, true);
    }

    public StreamReaderThread(InputStream input, Charset charset, boolean storeContent) {
        this.input = input;
        this.charset = charset;
        this.storeContent = storeContent;
        this.start();
    }

    @Override
    public synchronized void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.input, this.charset));
        char[] buffer = new char[1024];
        try {
            int read = 0;
            while ((read = reader.read(buffer)) != -1) {
                if (!this.storeContent) continue;
                this.content.append(buffer, 0, read);
            }
        }
        catch (IOException e) {
            this.exception = e;
            this.content.append(e);
        }
    }

    public synchronized String getContent() {
        return this.content.toString();
    }

    public IOException getException() {
        return this.exception;
    }
}

