/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.lang;

import java.util.Comparator;
import java.util.function.IntSupplier;

public class ObjectUtils {
    public static <T extends Comparable<T>> int compareNullSafe(T object1, T object2) {
        return ObjectUtils.compareNullSafe(object1, object2, Comparable::compareTo);
    }

    public static <T> int compareNullSafe(T object1, T object2, Comparator<T> comparator) {
        if (object1 == object2) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return comparator.compare(object1, object2);
    }

    public static int compareInOrder(IntSupplier ... comparisonSuppliers) {
        for (IntSupplier comparisonSupplier : comparisonSuppliers) {
            int comparisonResult = comparisonSupplier.getAsInt();
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        return 0;
    }
}

