/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.net;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class UrlUtils {
    public static final String FILE_PROTOCOL = "file://";

    public static URI convertUriFromUrl(String url) throws URISyntaxException {
        if (url.startsWith(FILE_PROTOCOL)) {
            return new File(url.substring(FILE_PROTOCOL.length())).toURI();
        }
        return new URI(url);
    }

    public static void checkHttpConnection(String url) throws IOException {
        HttpURLConnection connection = null;
        try {
            URL testUrl = new URL(url);
            connection = (HttpURLConnection)testUrl.openConnection();
            connection.connect();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String encodeToUtf8(String parameter) {
        try {
            return URLEncoder.encode(parameter, FileSystemUtils.UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Encoding " + parameter + " to UTF-8 failed: " + e.getMessage(), e);
        }
    }

    public static String decodeFromUtf8(String parameter) {
        try {
            return URLDecoder.decode(parameter, FileSystemUtils.UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Decoding " + parameter + " from UTF-8 failed: " + e.getMessage(), e);
        }
    }
}

