/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.options.OptionApplicator;
import org.conqat.lib.commons.options.OptionHandler;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public class OptionRegistry {
    private final Map<Character, OptionApplicator> shortOptions = new HashMap<Character, OptionApplicator>();
    private final Map<String, OptionApplicator> longOptions = new HashMap<String, OptionApplicator>();
    private final List<Option> allOptions = new ArrayList<Option>();

    public OptionRegistry() {
    }

    public OptionRegistry(Object optionHandler) {
        this.registerOptionHandler(optionHandler);
    }

    public void registerOptionHandler(Object optionHandler) {
        for (Method method : optionHandler.getClass().getMethods()) {
            Option optionDescriptor = method.getAnnotation(Option.class);
            if (optionDescriptor == null) continue;
            this.registerOption(optionHandler, method, optionDescriptor);
        }
        for (Field field : ReflectionUtils.getAllFields(optionHandler.getClass())) {
            OptionHandler nestedHandler = field.getAnnotation(OptionHandler.class);
            if (nestedHandler == null) continue;
            try {
                field.setAccessible(true);
                Object nestedHandlerValue = field.get(optionHandler);
                CCSMAssert.isNotNull(nestedHandlerValue, () -> "Option handler " + field.getName() + " is null!");
                this.registerOptionHandler(nestedHandlerValue);
            }
            catch (IllegalAccessException e) {
                CCSMAssert.fail("Option handler " + field.getName() + " is not accessible!", e);
            }
        }
    }

    private void registerOption(Object optionHandler, Method m, Option optionDescriptor) {
        this.allOptions.add(optionDescriptor);
        OptionApplicator applicator = new OptionApplicator(optionHandler, m, optionDescriptor.greedy());
        if (optionDescriptor.shortName() != '\u0000') {
            OptionRegistry.registerApplicator(applicator, this.shortOptions, Character.valueOf(optionDescriptor.shortName()));
        }
        if (optionDescriptor.longName().length() > 0) {
            OptionRegistry.registerApplicator(applicator, this.longOptions, optionDescriptor.longName());
        }
    }

    private static <T> void registerApplicator(OptionApplicator applicator, Map<T, OptionApplicator> map, T optionName) {
        if (map.containsKey(optionName)) {
            throw new IllegalArgumentException("An option of the name " + optionName + " already exists!");
        }
        map.put(optionName, applicator);
    }

    public OptionApplicator getShortOption(char name) {
        return this.shortOptions.get(Character.valueOf(name));
    }

    public OptionApplicator getLongOption(String name) {
        return this.longOptions.get(name);
    }

    public List<Option> getAllOptions() {
        return this.allOptions;
    }
}

