/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.predicate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;

public class PredicateUtils {
    public static <T> List<T> obtainContained(Collection<T> input, Predicate<? super T> predicate) {
        return input.stream().filter(predicate).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> Pair<List<T>, List<T>> splitContainedNonContained(Collection<T> input, Predicate<? super T> predicate) {
        ArrayList<T> contained = new ArrayList<T>();
        ArrayList<T> nonContained = new ArrayList<T>();
        for (T t : input) {
            if (predicate.test(t)) {
                contained.add(t);
                continue;
            }
            nonContained.add(t);
        }
        return new Pair<List<T>, List<T>>(contained, nonContained);
    }

    public static <T> List<T> obtainNonContained(Collection<T> input, Predicate<? super T> predicate) {
        return PredicateUtils.obtainContained(input, predicate.negate());
    }

    public static <T> Predicate<T> alwaysTrue() {
        return t -> true;
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return t -> !predicate.test(t);
    }
}

