/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.resources;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import nonapi.io.github.classgraph.scanspec.AcceptReject;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

public class ResourceUtils {
    public static List<Resource> listResources(Class<?> contextClass, String path) {
        return ResourceUtils.listResources(contextClass, path, false);
    }

    public static List<Resource> listResourcesRecursively(Class<?> contextClass, String path) {
        return ResourceUtils.listResources(contextClass, path, true);
    }

    public static String getPackageResourcePath(Class<?> contextClass) {
        return contextClass.getPackage().getName().replace('.', '/');
    }

    private static List<Resource> listResources(Class<?> contextClass, String path, boolean recursive) {
        return CollectionUtils.map(ResourceUtils.listResourceNames(contextClass, path, recursive), resourcePath -> Resource.of(contextClass, resourcePath));
    }

    private static List<String> listResourceNames(Class<?> contextClass, String path, boolean recursive) {
        String contextPath = AcceptReject.packageNameToPath((String)contextClass.getPackage().getName());
        String fullPath = ResourceUtils.determineAbsoluteResourcePath(contextPath, path);
        ClassGraph classGraph = new ClassGraph();
        classGraph = recursive ? classGraph.acceptPaths(new String[]{fullPath}) : classGraph.acceptPathsNonRecursive(new String[]{fullPath});
        HashSet resources = new HashSet();
        try (ScanResult scanResult = classGraph.scan();){
            scanResult.getAllResources().nonClassFilesOnly().forEach(res -> {
                String resourceFullPath = res.getPath();
                if (path.startsWith("/")) {
                    resources.add('/' + resourceFullPath);
                } else {
                    resources.add(StringUtils.stripPrefix(resourceFullPath, contextPath + '/'));
                }
            });
        }
        return new ArrayList<String>(resources);
    }

    private static String determineAbsoluteResourcePath(String contextPath, String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String fullPath = contextPath;
        if (!StringUtils.isEmpty(path)) {
            fullPath = fullPath + '/' + path;
        }
        return fullPath;
    }
}

