/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.string.StringUtils;

public class SerializedEntityPool {
    public static final int NULL_HANDLE = 0;
    static final int START_HANDLE = 0x7E0000;
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private int nextHandle = 0x7E0000;
    private final Map<Integer, SerializedEntityBase> entities = new HashMap<Integer, SerializedEntityBase>();
    private final List<Integer> rootHandles = new ArrayList<Integer>();
    private final List<SerializedClass> classEntities = new ArrayList<SerializedClass>();

    public void reset() {
        this.nextHandle = 0x7E0000;
        this.entities.clear();
        this.rootHandles.clear();
        this.classEntities.clear();
    }

    int addEntity(SerializedEntityBase entity) {
        if (entity instanceof SerializedClass) {
            this.classEntities.add((SerializedClass)entity);
        }
        int handle = this.nextHandle++;
        this.entities.put(handle, entity);
        return handle;
    }

    public boolean containsHandle(int handle) {
        return this.entities.containsKey(handle);
    }

    private SerializedEntityBase getEntity(int handle) throws IOException {
        if (handle == 0) {
            return null;
        }
        SerializedEntityBase entity = this.entities.get(handle);
        if (entity == null) {
            throw new IOException("No entity registered for handle " + handle);
        }
        return entity;
    }

    public <T extends SerializedEntityBase> T getEntity(int handle, Class<T> expectedType) throws IOException {
        SerializedEntityBase entity = this.getEntity(handle);
        if (entity == null) {
            return null;
        }
        if (!expectedType.isInstance(entity)) {
            throw new IOException("Expected type " + expectedType + " for handle " + handle + " but was " + entity.getClass());
        }
        return (T)entity;
    }

    public <T extends SerializedEntityBase> List<T> getEntities(Class<T> expectedType) throws IOException {
        return SerializedEntityPool.getEntitiesForType(this.entities.values(), expectedType);
    }

    public <T extends SerializedEntityBase> List<T> getRootEntities(Class<T> expectedType) throws IOException {
        return SerializedEntityPool.getEntitiesForType(this.getRootEntities(), expectedType);
    }

    private static <T extends SerializedEntityBase> List<T> getEntitiesForType(Collection<? extends SerializedEntityBase> entities, Class<T> expectedType) {
        ArrayList<SerializedEntityBase> returnEntities = new ArrayList<SerializedEntityBase>();
        for (SerializedEntityBase serializedEntityBase : entities) {
            if (!expectedType.isInstance(serializedEntityBase)) continue;
            returnEntities.add(serializedEntityBase);
        }
        return returnEntities;
    }

    public List<SerializedEntityBase> getRootEntities() throws IOException {
        ArrayList<SerializedEntityBase> rootEntities = new ArrayList<SerializedEntityBase>();
        for (int handle : this.rootHandles) {
            rootEntities.add(this.getEntity(handle));
        }
        return rootEntities;
    }

    public void registerRootHandle(int handle) throws IOException {
        if (handle != 0 && !this.containsHandle(handle)) {
            throw new IOException("Can not register unknown handle " + handle + " as root!");
        }
        this.rootHandles.add(handle);
    }

    public SerializedClass findClass(String name) {
        for (SerializedClass classEntity : this.classEntities) {
            if (!classEntity.getName().equals(name)) continue;
            return classEntity;
        }
        return null;
    }

    public void renameClass(String oldName, String newName) {
        SerializedClass serializedClass = this.findClass(oldName);
        if (serializedClass != null) {
            serializedClass.setName(newName);
        }
    }

    public void assertAllPlainClassNamesMatch(Function<String, Boolean> matcher, String message) {
        for (SerializedClass classEntity : this.classEntities) {
            String plainClassName = StringUtils.stripPrefix(classEntity.getName(), NON_PRIMITIVE_ARRAY_PREFIX);
            if (matcher.apply(plainClassName).booleanValue()) continue;
            CCSMAssert.fail(message + ": " + plainClassName);
        }
    }

    public int getOrCreateClass(String className, SerializedFieldBase ... fields) {
        SerializedClass clazz = this.findClass(className);
        if (clazz == null) {
            clazz = SerializedClass.createClass(this, className);
            for (SerializedFieldBase field : fields) {
                clazz.addField(field);
            }
        }
        return clazz.getHandle();
    }
}

