/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.objects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.classes.SerializedPrimitiveFieldBase;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;

public class SerializedArrayObject
extends SerializedObjectBase {
    private final List<Object> values = new ArrayList<Object>();
    private final SerializedFieldBase elementType;

    public SerializedArrayObject(DataInputStream din, SerializedEntityPool pool, SerializedEntityParser parser, int classHandle) throws IOException {
        super(pool, classHandle);
        String className = pool.getEntity(classHandle, SerializedClass.class).getName();
        this.elementType = className.length() == 2 && className.charAt(0) == '[' ? SerializedPrimitiveFieldBase.fromTypeCode(className.charAt(1), null) : new SerializedObjectField();
        int size = din.readInt();
        for (int i = 0; i < size; ++i) {
            this.values.add(this.elementType.readValue(din, parser));
        }
    }

    @Override
    protected byte getObjectTagConstant() {
        return 117;
    }

    @Override
    protected void serializeObjectContent(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        dos.writeInt(this.values.size());
        for (Object value : this.values) {
            this.elementType.writeValue(value, this.pool, dos, serializer);
        }
    }
}

