/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import org.conqat.lib.commons.string.StringUtils;

public enum ENewline {
    UNIX("\n"),
    WINDOWS("\r\n"),
    MAC("\r");

    private final String newline;

    private ENewline(String newline) {
        this.newline = newline;
    }

    public String getNewline() {
        return this.newline;
    }

    public String convertNewlines(String input) {
        return StringUtils.replaceLineBreaks(input, this.newline);
    }

    public static ENewline guessNewline(String string) {
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        boolean previousWasCR = false;
        for (char c : string.toCharArray()) {
            if (c == '\r') {
                previousWasCR = true;
                ++crCount;
                continue;
            }
            if (c == '\n') {
                if (previousWasCR) {
                    ++crlfCount;
                    --crCount;
                } else {
                    ++lfCount;
                }
                previousWasCR = false;
                continue;
            }
            previousWasCR = false;
        }
        if (crlfCount > lfCount && crlfCount > crCount) {
            return WINDOWS;
        }
        if (lfCount > crCount) {
            return UNIX;
        }
        if (crCount == 0) {
            return ENewline.guessNewline(StringUtils.LINE_SEPARATOR);
        }
        return MAC;
    }
}

