/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.Arrays;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ManagedIntArray;

public class LineOffsetConverter
extends ManagedIntArray {
    public LineOffsetConverter(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\n') {
                this.addArrayElement();
                this.array[this.size - 1] = i;
                continue;
            }
            if (chars[i] != '\r' || i + 1 < chars.length && chars[i + 1] == '\n') continue;
            this.addArrayElement();
            this.array[this.size - 1] = i;
        }
        this.addArrayElement();
        this.array[this.size - 1] = chars.length;
    }

    public int getLineCount() {
        return this.size;
    }

    public int getOffset(int line) {
        CCSMAssert.isTrue(this.isValidLine(line), "This is not a valid line: " + line + " Valid: [0-" + (this.size + 1) + "]");
        if (line == 1) {
            return 0;
        }
        return this.array[line - 2] + 1;
    }

    public boolean isValidLine(int line) {
        return 1 <= line && line <= this.size + 1;
    }

    public int getLine(int offset) {
        CCSMAssert.isTrue(offset >= 0, "Negative offsets not supported!");
        int index = Arrays.binarySearch(this.array, 0, this.size, offset);
        if (index >= 0) {
            return index + 1;
        }
        return Math.min(-index, this.size);
    }
}

