/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class StringUndoStackBase {
    private final List<Diff.Delta<String>> deltas = new ArrayList<Diff.Delta<String>>();
    private String currentVersion;
    private int currentVersionIndex = -1;
    private int savePosition = -1;

    protected StringUndoStackBase(String initialString) {
        this.currentVersion = initialString;
    }

    public boolean canUndo() {
        return this.currentVersionIndex >= 0;
    }

    public void undo() {
        CCSMAssert.isTrue(this.canUndo(), "Must be allowed to undo!");
        this.currentVersion = this.join(this.deltas.get(this.currentVersionIndex--).backwardPatch(this.split(this.currentVersion)));
        this.setModelFromString(this.currentVersion);
        this.fireStackChanged();
    }

    public boolean canRedo() {
        return this.currentVersionIndex + 1 < this.deltas.size();
    }

    public void redo() {
        CCSMAssert.isTrue(this.canRedo(), "Must be allowed to redo!");
        this.currentVersion = this.join(this.deltas.get(++this.currentVersionIndex).forwardPatch(this.split(this.currentVersion)));
        this.setModelFromString(this.currentVersion);
        this.fireStackChanged();
    }

    public boolean isDirty() {
        return this.currentVersionIndex != this.savePosition;
    }

    public void doSave() {
        this.savePosition = this.currentVersionIndex;
    }

    protected void insertNewVersion(String s) {
        ++this.currentVersionIndex;
        if (this.savePosition >= this.currentVersionIndex) {
            this.savePosition = -1;
        }
        while (this.deltas.size() > this.currentVersionIndex) {
            this.deltas.remove(this.deltas.size() - 1);
        }
        this.deltas.add(Diff.computeDelta(this.split(this.currentVersion), this.split(s)));
        this.currentVersion = s;
        this.fireStackChanged();
    }

    protected abstract List<String> split(String var1);

    protected abstract String join(List<String> var1);

    protected abstract void setModelFromString(String var1);

    protected abstract void fireStackChanged();

    protected int debugGetSize() {
        int size = 2 * this.currentVersion.length();
        for (Diff.Delta<String> delta : this.deltas) {
            for (int i = 0; i < delta.getSize(); ++i) {
                size += 4 + 2 * delta.getT(i).length();
            }
        }
        return 2 * size;
    }
}

