/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.system;

import org.conqat.lib.commons.system.EPerformanceMonitorState;
import org.conqat.lib.commons.system.MemoryMonitor;

public class PerformanceMonitor {
    private EPerformanceMonitorState state = EPerformanceMonitorState.NOT_RUN;
    private MemoryMonitor memMonitor;
    private final boolean useMemoryMonitor;
    private long startTimeInMillis;
    private long startMemoryInBytes;
    private long totalSpentTimeInMillis = 0L;
    private long maxMemoryInBytes = 0L;

    public PerformanceMonitor(boolean useMemoryMonitor) {
        this.useMemoryMonitor = useMemoryMonitor;
    }

    public static PerformanceMonitor create(boolean useMemoryMonitor) {
        PerformanceMonitor monitor = new PerformanceMonitor(useMemoryMonitor);
        monitor.start();
        return monitor;
    }

    public static PerformanceMonitor create() {
        return PerformanceMonitor.create(false);
    }

    public void start() {
        long currentMemoryInBytes = Runtime.getRuntime().totalMemory();
        if (this.state == EPerformanceMonitorState.RUNNING) {
            throw new IllegalStateException("PerformanceMonitor is already running and cannot be restarted");
        }
        if (this.state == EPerformanceMonitorState.NOT_RUN) {
            this.startMemoryInBytes = currentMemoryInBytes;
        }
        this.state = EPerformanceMonitorState.RUNNING;
        if (this.useMemoryMonitor) {
            this.memMonitor = new MemoryMonitor();
            this.memMonitor.start();
        }
        this.maxMemoryInBytes = Math.max(currentMemoryInBytes, this.maxMemoryInBytes);
        this.startTimeInMillis = System.currentTimeMillis();
    }

    public long stop() {
        if (this.state != EPerformanceMonitorState.RUNNING) {
            throw new IllegalStateException("PerformanceMonitor can only be stopped if it is running");
        }
        this.totalSpentTimeInMillis += System.currentTimeMillis() - this.startTimeInMillis;
        this.maxMemoryInBytes = Math.max(Runtime.getRuntime().totalMemory(), this.maxMemoryInBytes);
        this.state = EPerformanceMonitorState.FINISHED;
        if (this.useMemoryMonitor) {
            this.memMonitor.stop();
        }
        return this.getMilliseconds();
    }

    public boolean isStopped() {
        return this.state == EPerformanceMonitorState.FINISHED;
    }

    public long getSeconds() {
        return this.getMilliseconds() / 1000L;
    }

    public long getMilliseconds() {
        if (this.state == EPerformanceMonitorState.RUNNING) {
            return System.currentTimeMillis() - this.startTimeInMillis + this.totalSpentTimeInMillis;
        }
        return this.totalSpentTimeInMillis;
    }

    public long getMaxMemUsageInBytes() {
        if (this.useMemoryMonitor) {
            return this.memMonitor.getMaximumMemoryUsage();
        }
        return this.maxMemoryInBytes;
    }

    public long getMaxMemUsageInKBs() {
        return this.getMaxMemUsageInBytes() / 1024L;
    }

    public long getDeltaMemUsageInBytes() {
        return this.getMaxMemUsageInBytes() - this.startMemoryInBytes;
    }

    public long getDeltaMemUsageInKBs() {
        return this.getDeltaMemUsageInBytes() / 1024L;
    }
}

