/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.system;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class SystemUtils {
    public static EOperatingSystem getOperatingSystem() {
        return EOperatingSystem.getCurrent();
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public static boolean isWindows() {
        return SystemUtils.getOperatingSystem() == EOperatingSystem.WINDOWS;
    }

    public static boolean isMac() {
        return SystemUtils.getOperatingSystem() == EOperatingSystem.MAC;
    }

    public static boolean isLinux() {
        return SystemUtils.getOperatingSystem() == EOperatingSystem.LINUX;
    }

    public static String getJVMArchitectureName() {
        return System.getProperty("os.arch");
    }

    public static boolean is64BitJVM() {
        return SystemUtils.getJVMArchitectureName().contains("64");
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    public static String getUnsatisfiedLinkageErrorMessage(String libraryName) {
        String baseMessage = "Failed to load " + libraryName + " native library.";
        if (SystemUtils.isWindows()) {
            return baseMessage + " As of Teamscale 5.6, the 'Microsoft Visual C++ Redistributable for Visual Studio 2015 - 2019' have to be installed and may be missing. Please download and install it from here: http://cqse.eu/cpp-redistributables";
        }
        if (SystemUtils.isLinux()) {
            return baseMessage + " Please ensure that you have glibc >= 2.15 and glibc++ >= 3.4.22 installed (e.g., Ubuntu 2018.04 or RHEL 8) or use our docker images.";
        }
        return baseMessage;
    }

    public static enum EOperatingSystem {
        WINDOWS,
        LINUX,
        MAC,
        UNKNOWN;


        private static EOperatingSystem getCurrent() {
            String osName = SystemUtils.getOperatingSystemName().toUpperCase();
            for (EOperatingSystem system : EOperatingSystem.values()) {
                if (!osName.startsWith(system.name())) continue;
                return system;
            }
            return UNKNOWN;
        }
    }
}

