/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.tree;

import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.string.StringUtils;

public class Trie<T> {
    private TrieNode root = new TrieNode();

    public void put(String prefix, T value) {
        TrieNode currentNode = this.root;
        for (Character ch : StringUtils.splitChars(prefix)) {
            TrieNode nextNode = (TrieNode)currentNode.next.get(ch);
            if (nextNode == null) {
                nextNode = new TrieNode();
                currentNode.next.put(ch, nextNode);
            }
            currentNode = nextNode;
        }
        currentNode.value = value;
    }

    public T getLongestPrefix(String sequence) {
        Object currentBestMatch = null;
        TrieNode currentNode = this.root;
        for (Character ch : StringUtils.splitChars(sequence)) {
            if ((currentNode = (TrieNode)currentNode.next.get(ch)) == null) {
                return (T)currentBestMatch;
            }
            if (currentNode.value == null) continue;
            currentBestMatch = currentNode.value;
        }
        return (T)currentBestMatch;
    }

    private class TrieNode {
        private T value;
        private Map<Character, TrieNode> next = new HashMap<Character, TrieNode>();

        private TrieNode() {
        }
    }
}

