/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.conqat.lib.commons.color.MultiColor;
import org.conqat.lib.commons.treemap.IDrawingPattern;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.treemap.ITreeMapRenderer;

public class FlatTreeMapRenderer
implements ITreeMapRenderer {
    @Override
    public <T> void renderTreeMap(ITreeMapNode<T> node, Graphics2D graphics) {
        if (node.getChildren().isEmpty()) {
            Rectangle2D rect = node.getLayoutRectangle();
            if (rect == null) {
                return;
            }
            this.fillRect(graphics, rect, node.getColor());
            if (node.getDrawingPattern() != null) {
                FlatTreeMapRenderer.drawPattern(graphics, rect, node);
            }
            graphics.setColor(Color.BLACK);
            graphics.draw(rect);
        } else {
            for (ITreeMapNode<T> child : node.getChildren()) {
                this.renderTreeMap(child, graphics);
            }
        }
    }

    private void fillRect(Graphics2D graphics, Rectangle2D rect, Color color) {
        if (color instanceof MultiColor) {
            this.fillRectMultiColor(graphics, rect, (MultiColor)color);
        } else {
            graphics.setColor(color);
            graphics.fill(rect);
        }
    }

    private void fillRectMultiColor(Graphics2D graphics, Rectangle2D rect, MultiColor multiColor) {
        double x = rect.getX();
        double y = rect.getY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        double offset = 0.0;
        for (int i = 0; i < multiColor.size(); ++i) {
            double relativeFrequency = multiColor.getRelativeFrequency(i);
            Rectangle2D.Double subrect = width > height ? new Rectangle2D.Double(x + offset * width, y, width * relativeFrequency, height) : new Rectangle2D.Double(x, y + offset * height, width, height * relativeFrequency);
            this.fillRect(graphics, subrect, multiColor.getColor(i));
            offset += relativeFrequency;
        }
    }

    private static <T> void drawPattern(Graphics2D graphics, Rectangle2D rect, ITreeMapNode<T> node) {
        IDrawingPattern drawingPattern = node.getDrawingPattern();
        graphics.setColor(node.getPatternColor());
        int x = (int)rect.getMinX();
        while ((double)x <= rect.getMaxX()) {
            int y = (int)rect.getMinY();
            while ((double)y <= rect.getMaxY()) {
                if (drawingPattern.isForeground(x, y)) {
                    graphics.fill(new Rectangle(x, y, 1, 1));
                }
                ++y;
            }
            ++x;
        }
    }
}

