/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.treemap.ITreeMapRenderer;

public class NodeTextRenderer
implements ITreeMapRenderer {
    private static final int TEXT_PADDING = 5;
    private final Color textColor;
    private final Pattern separationPattern;

    public NodeTextRenderer(Color textColor, Pattern separationPattern) {
        this.textColor = textColor;
        this.separationPattern = separationPattern;
    }

    @Override
    public <T> void renderTreeMap(ITreeMapNode<T> node, Graphics2D graphics) {
        if (node.getChildren().isEmpty()) {
            Rectangle2D nodeArea = node.getLayoutRectangle();
            if (nodeArea == null) {
                return;
            }
            if (NodeTextRenderer.enoughSpace(nodeArea)) {
                this.drawText(node.getText(), nodeArea, graphics);
            }
        } else {
            for (ITreeMapNode<T> child : node.getChildren()) {
                this.renderTreeMap(child, graphics);
            }
        }
    }

    private static boolean enoughSpace(Rectangle2D nodeArea) {
        return nodeArea.getWidth() > 15.0 && nodeArea.getHeight() > 15.0;
    }

    private void drawText(String text, Rectangle2D availableSpace, Graphics2D graphics) {
        String fittedText = this.clipTextToWidth(text, availableSpace.getWidth(), graphics);
        if (fittedText.length() < text.length()) {
            fittedText = fittedText + "...";
        }
        int x = (int)availableSpace.getCenterX() - NodeTextRenderer.actualWidth(fittedText, graphics) / 2;
        int y = (int)availableSpace.getCenterY() + NodeTextRenderer.actualHeight(fittedText, graphics) / 2;
        graphics.setColor(this.textColor);
        graphics.drawString(fittedText, x, y);
    }

    private String clipTextToWidth(String text, double width, Graphics2D graphics) {
        String[] parts;
        double availableWidth = width - 10.0;
        if (this.separationPattern != null && (double)NodeTextRenderer.actualWidth(text, graphics) > availableWidth && (parts = this.separationPattern.split(text)).length > 0) {
            text = parts[parts.length - 1];
        }
        if ((double)NodeTextRenderer.actualWidth(text, graphics) > availableWidth) {
            availableWidth -= (double)NodeTextRenderer.actualWidth("...", graphics);
        }
        while (text.length() > 0 && (double)NodeTextRenderer.actualWidth(text, graphics) > availableWidth) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private static int actualWidth(String label, Graphics2D graphics) {
        return (int)NodeTextRenderer.actualBounds(label, graphics).getWidth();
    }

    private static int actualHeight(String label, Graphics2D graphics) {
        return (int)NodeTextRenderer.actualBounds(label, graphics).getHeight();
    }

    private static Rectangle2D actualBounds(String label, Graphics2D graphics) {
        return graphics.getFont().getStringBounds(label, graphics.getFontRenderContext());
    }
}

