/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.version;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public final class Version
implements Comparable<Version>,
Serializable {
    private static final String MAJOR_PROPERTY = "major";
    private static final String MINOR_PROPERTY = "minor";
    private static final String PATCH_PROPERTY = "patch";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="major")
    private final int major;
    @JsonProperty(value="minor")
    private final int minor;
    @JsonProperty(value="patch")
    private final int patch;

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    @JsonCreator
    public Version(@JsonProperty(value="major") int major, @JsonProperty(value="minor") int minor, @JsonProperty(value="patch") int patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Versions may not be less than 0.");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version parseVersion(String s) throws FormatException {
        Matcher m = Pattern.compile("\\s*(\\d+)\\.(\\d+)(?:\\.(\\d+))?\\s*").matcher(s);
        if (!m.matches()) {
            throw new FormatException("The provided string did not match the pattern!");
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        int patch = Optional.ofNullable(m.group(3)).map(Integer::parseInt).orElse(0);
        return new Version(major, minor, patch);
    }

    @Override
    public int compareTo(Version other) {
        return Comparator.comparingInt(Version::getMajor).thenComparingInt(Version::getMinor).thenComparingInt(Version::getPatch).compare(this, other);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean isSatisfied(Version currentVersion, Version compatibleVersion) {
        if (compatibleVersion.compareTo(currentVersion) > 0) {
            throw new IllegalArgumentException("Compatible version greater than current version.");
        }
        return this.compareTo(currentVersion) <= 0 && this.compareTo(compatibleVersion) >= 0;
    }

    public boolean isGreaterOrEqual(Version other) {
        return this.compareTo(other) >= 0;
    }

    public String toString() {
        String result = this.major + "." + this.minor;
        if (this.patch > 0) {
            result = result + "." + this.patch;
        }
        return result;
    }
}

