/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLResolver;
import org.conqat.lib.commons.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ATTRIBUTE_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String FEATURE_LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    private static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String SCHEMA_URL = "http://www.w3.org/2001/XMLSchema";
    private static final String ATTRIBUTE_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";

    public static <ElementsEnum extends Enum<ElementsEnum>, AttributesEnum extends Enum<AttributesEnum>> XMLWriter<ElementsEnum, AttributesEnum> createUtf8Writer(File outputFile, Class<AttributesEnum> attributesClass) throws FileNotFoundException, UnsupportedEncodingException {
        return new XMLWriter(new PrintStream(outputFile, FileSystemUtils.UTF8_ENCODING), new XMLResolver(attributesClass));
    }

    public static Document parse(File file) throws SAXException, IOException {
        return XMLUtils.createSchemaUnawareParser().parse(file);
    }

    public static Document parse(InputSource input) throws SAXException, IOException {
        return XMLUtils.createSchemaUnawareParser().parse(input);
    }

    public static void parseSAX(File file, DefaultHandler handler) throws SAXException, IOException {
        XMLUtils.createSchemaUnawareSAXParser().parse(file, handler);
    }

    public static void parseSAX(InputSource input, DefaultHandler handler) throws SAXException, IOException {
        XMLUtils.createSchemaUnawareSAXParser().parse(input, handler);
    }

    public static void parseSAX(String content, DefaultHandler handler) throws SAXException, IOException {
        XMLUtils.parseSAX(new InputSource(new ByteArrayInputStream(StringUtils.stringToBytes(content))), handler);
    }

    public static Document parse(File file, URL schemaURL) throws SAXException, IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            Document document = XMLUtils.parse(new InputSource(stream), schemaURL);
            return document;
        }
    }

    public static Document parse(InputSource input, URL schemaURL) throws SAXException, IOException {
        CCSMAssert.isTrue(schemaURL != null, "Schema URL may not be null!");
        DocumentBuilder parser = XMLUtils.createSchemaAwareParser(schemaURL);
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        parser.setErrorHandler(errorHandler);
        Document document = parser.parse(input);
        if (errorHandler.exception != null) {
            throw errorHandler.exception;
        }
        return document;
    }

    public static void parseSAX(File file, URL schemaURL, DefaultHandler handler) throws SAXException, IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            XMLUtils.parseSAX(new InputSource(stream), schemaURL, handler);
        }
    }

    public static void parseSAX(InputSource input, URL schemaURL, DefaultHandler handler) throws SAXException, IOException {
        CCSMAssert.isTrue(schemaURL != null, "Schema URL may not be null!");
        XMLUtils.createSchemaAwareSAXParser(schemaURL).parse(input, handler);
    }

    private static DocumentBuilder createSchemaUnawareParser() {
        try {
            return XMLUtils.createNamespaceAwareDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No document builder found, probably Java is misconfigured!", e);
        }
    }

    private static SAXParser createSchemaUnawareSAXParser() throws SAXException {
        try {
            return XMLUtils.createSAXParser(false);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No SAX parser found, probably Java is misconfigured!", e);
        }
    }

    private static DocumentBuilder createSchemaAwareParser(URL schemaURL) {
        try {
            DocumentBuilderFactory dbf = XMLUtils.createNamespaceAwareDocumentBuilderFactory();
            dbf.setValidating(true);
            dbf.setAttribute(ATTRIBUTE_SCHEMA_LANGUAGE, SCHEMA_URL);
            dbf.setAttribute(ATTRIBUTE_SCHEMA_SOURCE, schemaURL.toString());
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No document builder found, probably Java is misconfigured!", e);
        }
    }

    private static SAXParser createSchemaAwareSAXParser(URL schemaURL) throws SAXException {
        try {
            SAXParser parser = XMLUtils.createSAXParser(true);
            parser.setProperty(ATTRIBUTE_SCHEMA_LANGUAGE, SCHEMA_URL);
            parser.setProperty(ATTRIBUTE_SCHEMA_SOURCE, schemaURL.toString());
            return parser;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("No SAX parser found, probably Java is misconfigured!", e);
        }
    }

    private static DocumentBuilderFactory createNamespaceAwareDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbf.setFeature(FEATURE_LOAD_DTD_GRAMMAR, false);
        dbf.setFeature(FEATURE_LOAD_EXTERNAL_DTD, false);
        dbf.setNamespaceAware(true);
        return dbf;
    }

    private static SAXParser createSAXParser(boolean validating) throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(validating);
        spf.setFeature(FEATURE_LOAD_DTD_GRAMMAR, false);
        spf.setFeature(FEATURE_LOAD_EXTERNAL_DTD, false);
        SAXParser parser = spf.newSAXParser();
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return parser;
    }

    public static Document parse(File file, File schema) throws SAXException, IOException {
        try {
            return XMLUtils.parse(file, schema.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Schema file could not be converted to URL: ", e);
        }
    }

    public static String prettyPrint(Document doc) throws TransformerException {
        URL url = XMLUtils.class.getResource("pretty.xsl");
        StreamSource xslSource = new StreamSource(url.toExternalForm());
        Transformer transformer = XMLUtils.createTransformerFactory().newTransformer(xslSource);
        return StringUtils.normalizeLineSeparatorsPlatformSpecific(XMLUtils.transformDocumentToString(doc, transformer));
    }

    public static String print(Document document) throws TransformerException {
        Transformer transformer = XMLUtils.createTransformerFactory().newTransformer();
        return XMLUtils.transformDocumentToString(document, transformer);
    }

    private static TransformerFactory createTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }

    private static String transformDocumentToString(Document document, Transformer transformer) throws TransformerException {
        DOMSource source = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult resultStream = new StreamResult(stringWriter);
        transformer.transform(source, resultStream);
        return stringWriter.toString();
    }

    public static List<Element> getNamedChildren(Element element, String elementNames) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(elementNames)) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static Element getNamedChild(Element element, String name) {
        List<Element> children = XMLUtils.getNamedChildren(element, name);
        if (!children.isEmpty()) {
            return children.get(0);
        }
        return null;
    }

    public static Element getLastNamedChild(Element element, String name) {
        List<Element> children = XMLUtils.getNamedChildren(element, name);
        if (!children.isEmpty()) {
            return CollectionUtils.getLast(children);
        }
        return null;
    }

    public static String getNamedChildContent(Element parent, String name) {
        Element element = XMLUtils.getNamedChild(parent, name);
        if (element == null) {
            return "";
        }
        return element.getTextContent();
    }

    public static Element getElementByChildContent(List<Element> elements, String childName, String childContent) {
        for (Element element : elements) {
            Element child = XMLUtils.getNamedChild(element, childName);
            if (child == null || !child.getTextContent().equals(childContent)) continue;
            return element;
        }
        return null;
    }

    public static Element getAncestor(Element element, int distance) {
        for (int i = 0; i < distance; ++i) {
            if (element == null) {
                return null;
            }
            element = CCSMAssert.checkedCast(element.getParentNode(), Element.class);
        }
        return element;
    }

    public static List<Element> elementNodes(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static void removeElement(Element element) {
        Node parent = element.getParentNode();
        if (parent != null) {
            parent.removeChild(element);
        }
    }

    public static Element appendChild(Element element, String tagName) {
        Element newElement = CCSMAssert.checkedCast(element.getOwnerDocument().createElement(tagName), Element.class);
        element.appendChild(newElement);
        return newElement;
    }

    public static Element appendChild(Element parent, String tagName, String textContent) {
        Element newElement = XMLUtils.appendChild(parent, tagName);
        newElement.setTextContent(textContent);
        return newElement;
    }

    public static List<Element> leafElementNodes(Element root) {
        ArrayList<Element> leafElementNodes = new ArrayList<Element>();
        XMLUtils.leafElementNodes(root, leafElementNodes);
        return leafElementNodes;
    }

    private static void leafElementNodes(Element root, List<Element> leafElementNodes) {
        List<Element> children = XMLUtils.elementNodes(root.getChildNodes());
        if (children.isEmpty()) {
            leafElementNodes.add(root);
        } else {
            for (Element child : children) {
                XMLUtils.leafElementNodes(child, leafElementNodes);
            }
        }
    }

    public static InputSource toInputSource(String string) {
        return new InputSource(new StringReader(string));
    }

    public static String fixIllegalXmlChars(String content) {
        String replacedContent = content.replaceAll("(?i)&(?!(lt|gt|amp|apos|quot|#x[0-9a-f]+|#\\d+);)", "&amp;");
        replacedContent = replacedContent.replaceAll("([\\x00-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f])", "");
        replacedContent = replacedContent.replaceAll("(?i)&#x0*([0-8bcef]|1[0-9a-f]|7f);", "");
        replacedContent = replacedContent.replaceAll("(?i)&#0*([0-8]|1[124-9]|2[0-9]|3[01]|127);", "");
        return replacedContent;
    }

    public static boolean validateAgainstDTD(String xml, String dtd) throws ParserConfigurationException, IOException, TransformerException, SAXException {
        String xmlWithDtd = XMLUtils.addInternalDtd(xml, dtd);
        SAXParser parser = XMLUtils.createSAXParser(true);
        XMLReader reader = parser.getXMLReader();
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        reader.setErrorHandler(errorHandler);
        reader.parse(XMLUtils.toInputSource(xmlWithDtd));
        return errorHandler.exception == null;
    }

    private static String addInternalDtd(String xml, String dtd) throws IOException, SAXException, TransformerException {
        Document doc = XMLUtils.parse(XMLUtils.toInputSource(xml));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("doctype-system", "");
        String xmlWithDoctypeTag = XMLUtils.transformDocumentToString(doc, transformer);
        return xmlWithDoctypeTag.replaceFirst("<!DOCTYPE .*?>", dtd);
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private SAXParseException exception;

        private XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
            if (this.exception == null) {
                this.exception = exception;
            }
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.error(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            LOGGER.info(this.getClass().getSimpleName() + " received a warning: " + exception.getMessage());
        }
    }
}

