/*
 * Decompiled with CFR 0.152.
 */
package com.teamtter.mavennatives.nativedependencies;

import com.teamtter.mavennatives.nativedependencies.ArtifactUnpackingException;
import com.teamtter.mavennatives.nativedependencies.IArtifactHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=IArtifactHandler.class)
public class ArtifactHandler
implements IArtifactHandler {
    private static final Logger log = LoggerFactory.getLogger(ArtifactHandler.class);
    private static List<String> zipLikeExtensions = Arrays.asList("jar", "zip", "gz");
    private static List<String> tarGzExensions = Arrays.asList("tar.gz", "tgz");
    private static List<String> _7zExtensions = Arrays.asList("7z", "7zip");

    @Override
    public void moveOrUnpackArtifactTo(File unpackingDir, Artifact artifact) {
        File artifactFile = artifact.getFile();
        ArtifactHandler.moveOrUnpackFileTo(unpackingDir, artifactFile);
    }

    public static void moveOrUnpackFileTo(File unpackingDir, File artifactFile) {
        String fileName = artifactFile.getName();
        String extension = FilenameUtils.getExtension((String)fileName);
        try {
            if (fileName.contains(".tar.") || tarGzExensions.contains(extension)) {
                log.info("Artifact {} will be uncompressed as tar-gz-like to {}", (Object)artifactFile, (Object)unpackingDir);
                String basename = FilenameUtils.getBaseName((String)artifactFile.getName());
                File uncompressedTarFile = new File(unpackingDir, basename);
                ArtifactHandler.uncompressAFile(artifactFile, unpackingDir);
                ArtifactHandler.uncompressAnArchive(uncompressedTarFile, unpackingDir);
                uncompressedTarFile.delete();
            } else if (zipLikeExtensions.contains(extension)) {
                log.info("Artifact {} will be uncompressed as zip-like to {}", (Object)artifactFile, (Object)unpackingDir);
                ArtifactHandler.uncompressAnArchive(artifactFile, unpackingDir);
            } else if (_7zExtensions.contains(extension)) {
                log.info("Artifact {} will be uncompressed as 7z to {}", (Object)artifactFile, (Object)unpackingDir);
                ArtifactHandler.uncompress7zArchive(artifactFile, unpackingDir);
            } else {
                log.info("Artifact {} can not be unpacked, will be moved as is to {}", (Object)artifactFile, (Object)unpackingDir);
                File targetFile = new File(unpackingDir, fileName);
                FileUtils.copyFile((File)artifactFile, (File)targetFile);
            }
        }
        catch (Exception e) {
            log.error("Error unpacking or moving artifact {}", (Object)artifactFile);
            throw new ArtifactUnpackingException(e);
        }
    }

    private static void uncompress7zArchive(File artifactFile, File unpackingDir) {
        try {
            SevenZFile sevenZFile = new SevenZFile(artifactFile);
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            while (entry != null) {
                File entryFile = new File(unpackingDir, entry.getName());
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                } else {
                    FileOutputStream out = new FileOutputStream(entryFile);
                    byte[] content = new byte[(int)entry.getSize()];
                    sevenZFile.read(content, 0, content.length);
                    out.write(content);
                    out.close();
                }
                entry = sevenZFile.getNextEntry();
            }
            sevenZFile.close();
        }
        catch (Exception e) {
            log.error("Unable to fully uncompress {} to {}", (Object)artifactFile, (Object)unpackingDir);
            throw new ArtifactUnpackingException(e);
        }
    }

    private static void uncompressAnArchive(File fileIn, File dirOut) {
        try {
            FileInputStream fin = new FileInputStream(fileIn);
            BufferedInputStream bis = new BufferedInputStream(fin);
            try (ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);){
                ArchiveEntry entry = null;
                ArrayList<TarArchiveEntry> tarEntriesSymlinks = new ArrayList<TarArchiveEntry>();
                while ((entry = ais.getNextEntry()) != null) {
                    TarArchiveEntry tarEntry;
                    if (entry.isDirectory()) continue;
                    File outFile = new File(dirOut, entry.getName());
                    outFile.getParentFile().mkdirs();
                    boolean isSpecialCase = false;
                    if (entry instanceof TarArchiveEntry && (tarEntry = (TarArchiveEntry)entry).isSymbolicLink()) {
                        isSpecialCase = true;
                        log.debug("File {} is a symlink", (Object)outFile);
                        tarEntriesSymlinks.add(tarEntry);
                    }
                    if (isSpecialCase) continue;
                    log.debug("File {} is not special", (Object)outFile);
                    FileOutputStream out = new FileOutputStream(outFile);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)ais, (OutputStream)out);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                for (TarArchiveEntry tarEntry : tarEntriesSymlinks) {
                    File outFile = new File(dirOut, tarEntry.getName());
                    Path linkTarget = new File(outFile.getParent(), tarEntry.getLinkName()).toPath();
                    try {
                        Files.createSymbolicLink(outFile.toPath(), linkTarget, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        log.warn("Unable to create symlink {} -> {} (maybe OS/filesystem does not support it ?)", (Object)outFile.toPath(), (Object)linkTarget);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Unable to fully uncompress {} to {}", (Object)fileIn, (Object)dirOut);
            throw new ArtifactUnpackingException(e);
        }
    }

    private static void uncompressAFile(File fileIn, File dirOut) {
        dirOut.mkdirs();
        try {
            FileInputStream fin = new FileInputStream(fileIn);
            BufferedInputStream bis = new BufferedInputStream(fin);
            try (CompressorInputStream cis = new CompressorStreamFactory().createCompressorInputStream((InputStream)bis);){
                String targetFileName = FilenameUtils.getBaseName((String)fileIn.getName());
                File outFile = new File(dirOut, targetFileName);
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    IOUtils.copy((InputStream)cis, (OutputStream)out);
                }
            }
        }
        catch (IOException | CompressorException e) {
            log.error("Unable to fully uncompress {} to {}", (Object)fileIn, (Object)dirOut);
            throw new ArtifactUnpackingException((Exception)e);
        }
    }

    public static void main(String[] args) {
        String destDir = "/media/vg1-data/Downloads/mvntest/out/";
        String sourceFile = "/media/vg1-data/Downloads/mvntest/archive.tar.gz";
        ArtifactHandler.moveOrUnpackFileTo(new File(destDir), new File(sourceFile));
    }
}

