/*
 * Decompiled with CFR 0.152.
 */
package com.teamtter.mavennatives.nativedependencies;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.teamtter.mavennatives.nativedependencies.AcceptEverythingOsFilter;
import com.teamtter.mavennatives.nativedependencies.IArtifactHandler;
import com.teamtter.mavennatives.nativedependencies.OsFilter;
import com.teamtter.mavennatives.nativedependencies.UnpackedArtifactsInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="copy", threadSafe=false, defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST, requiresProject=true)
public class CopyNativesMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(CopyNativesMojo.class);
    private static final String ALREADY_UNPACKED_ARTIFACTS_INFO_FILE = "alreadyUnpackedArtifactsInfo.json";
    public static final String NATIVES_PREFIX = "natives-";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="nativesTargetDir", defaultValue="${session.executionRootDirectory}/target/natives")
    private File nativesTargetDir;
    @Parameter(property="separateDirs", defaultValue="false")
    private boolean separateDirs;
    @Parameter(property="autoDetectOSNatives", defaultValue="false")
    private boolean autoDetectOSNatives;
    @Parameter(property="autoDetectDirUpInFilesystem", defaultValue="false")
    private boolean autoDetectDirUpInFilesystem;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private List<OsFilter> osFilters = new ArrayList<OsFilter>();
    @Component
    private IArtifactHandler artifactHandler;
    @Component
    private BuildContext buildContext;
    private static ObjectMapper jsonMapper = new ObjectMapper();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            log.info("Skipping execution due to 'skip' == true");
        } else {
            this.initOsFiltersIfNeeded();
            this.overrideNativesTargetDirIfNeeded();
            this.mavenProject.getProperties().put("nativesTargetDir", this.nativesTargetDir.toString());
            log.info("Natives will be saved in {} " + (this.separateDirs ? " and separated dirs according to classifier" : ""), (Object)this.nativesTargetDir);
            this.copyNativeDependencies();
        }
    }

    private void overrideNativesTargetDirIfNeeded() {
        if (this.autoDetectDirUpInFilesystem) {
            this.nativesTargetDir = new File(this.lookupUpperParentPom().getParentFile(), "/target/natives/");
            log.debug("nativesTargetDir overriden with {}", (Object)this.nativesTargetDir);
        }
    }

    private File lookupUpperParentPom() {
        File currentPom = new File(this.mavenProject.getBasedir(), "pom.xml");
        try {
            boolean upperPomFound = false;
            while (!upperPomFound) {
                MavenXpp3Reader currentReader = new MavenXpp3Reader();
                Model currentModel = currentReader.read((Reader)new FileReader(currentPom));
                Parent parent = currentModel.getParent();
                if (parent == null) {
                    log.trace("current pom has no parent and is THE upper pom: {}", (Object)currentPom);
                    upperPomFound = true;
                    continue;
                }
                String parentGroupId = parent.getGroupId();
                String parentArtifactId = parent.getArtifactId();
                File possibleParentPom = new File(currentPom.getParentFile().getParentFile(), "pom.xml");
                if (possibleParentPom.exists()) {
                    boolean groupIdOK;
                    MavenXpp3Reader possibleParentReader = new MavenXpp3Reader();
                    Model possibleParentModel = possibleParentReader.read((Reader)new FileReader(possibleParentPom));
                    String possibleParentGroupId = possibleParentModel.getGroupId();
                    String possibleParentArtifactId = possibleParentModel.getArtifactId();
                    boolean artifactIdOK = parentArtifactId.equals(possibleParentArtifactId);
                    boolean bl = groupIdOK = possibleParentGroupId == null || parentGroupId.equals(possibleParentGroupId);
                    if (artifactIdOK && groupIdOK) {
                        currentPom = possibleParentPom;
                        continue;
                    }
                    log.info("{} is not parent of {}", (Object)possibleParentPom, (Object)currentPom);
                    upperPomFound = true;
                    continue;
                }
                upperPomFound = true;
            }
        }
        catch (Exception e) {
            log.warn("Exception looking for parent pom.", (Throwable)e);
        }
        log.debug("found upper pom: {} ", (Object)currentPom);
        return currentPom;
    }

    private void initOsFiltersIfNeeded() {
        if (this.autoDetectOSNatives) {
            if (this.osFilters.size() != 0) {
                log.warn("Some OS filters have been set but will be overriden by auto-OS-detection. Please define filters OR set autoDetectOSNatives = true");
            }
            OsFilter thisComputer = new OsFilter(OsFilter.OS, null, this.getbasicOsTrigramm(OsFilter.OS));
            this.osFilters.add(thisComputer);
            log.debug("autoDetectOSNatives = true");
        } else if (this.osFilters.size() == 0) {
            log.debug("AcceptEverythingOsFilter will be used");
            this.osFilters.add(new AcceptEverythingOsFilter());
        } else {
            log.info("{} OS filters have been defined", (Object)this.osFilters.size());
        }
    }

    private String getbasicOsTrigramm(String os) {
        if (os.contains("win")) {
            return "win";
        }
        if (os.contains("lin")) {
            return "lin";
        }
        if (os.contains("mac")) {
            return "mac";
        }
        log.warn("unable to auto-detect OS...");
        return "";
    }

    private void copyNativeDependencies() throws MojoFailureException {
        boolean atLeastOneartifactCopied = false;
        UnpackedArtifactsInfo unpackedArtifactsInfo = this.loadAlreadyUnpackedArtifactsInfo();
        try {
            Set artifacts = this.mavenProject.getArtifacts();
            for (Artifact artifact : artifacts) {
                String classifier = artifact.getClassifier();
                if (this.artifactAlreadyUnpacked(unpackedArtifactsInfo, artifact)) {
                    log.debug("{} is already unpacked", (Object)this.artifactToString(artifact));
                    continue;
                }
                if (this.classifierMatchesConfig(classifier)) {
                    log.debug("{} => ok", (Object)this.artifactToString(artifact));
                    int i = 0;
                    this.handleDependancyCopyingOrUnpacking(artifact, classifier, unpackedArtifactsInfo);
                    atLeastOneartifactCopied = true;
                    ++i;
                    continue;
                }
                log.debug("{} => ko, native will be filtered out", (Object)this.artifactToString(artifact));
            }
        }
        catch (Exception e) {
            if (atLeastOneartifactCopied) {
                this.buildContext.refresh(this.nativesTargetDir);
            }
            throw new MojoFailureException("Unable to copy natives", (Throwable)e);
        }
        finally {
            if (atLeastOneartifactCopied) {
                this.writeAlreadyUnpackedArtifactsInfo(unpackedArtifactsInfo);
            }
        }
    }

    private UnpackedArtifactsInfo loadAlreadyUnpackedArtifactsInfo() {
        File file = new File(this.nativesTargetDir, ALREADY_UNPACKED_ARTIFACTS_INFO_FILE);
        UnpackedArtifactsInfo info = new UnpackedArtifactsInfo();
        if (file.exists()) {
            try {
                info = (UnpackedArtifactsInfo)jsonMapper.readValue(file, UnpackedArtifactsInfo.class);
            }
            catch (IOException e) {
                log.error("Unable to read file {}", (Object)file, (Object)e);
            }
        }
        return info;
    }

    private void writeAlreadyUnpackedArtifactsInfo(UnpackedArtifactsInfo unpackedArtifactsInfo) {
        File file = new File(this.nativesTargetDir, ALREADY_UNPACKED_ARTIFACTS_INFO_FILE);
        try {
            jsonMapper.writeValue(file, (Object)unpackedArtifactsInfo);
        }
        catch (IOException e) {
            log.error("Unable to write to file {}", (Object)file, (Object)e);
        }
    }

    private void handleDependancyCopyingOrUnpacking(Artifact artifact, String classifier, UnpackedArtifactsInfo unpackedArtifactsInfo) {
        log.info("Will unpack: " + this.artifactToString(artifact));
        File unpackingDir = this.computeUnpackingDir(classifier);
        this.artifactHandler.moveOrUnpackArtifactTo(unpackingDir, artifact);
        unpackedArtifactsInfo.flagAsUnpacked(artifact.getFile());
    }

    private boolean artifactAlreadyUnpacked(UnpackedArtifactsInfo unpackedArtifactsInfo, Artifact artifact) {
        File currentArtifactFile = artifact.getFile();
        boolean contains = false;
        if (unpackedArtifactsInfo.containsExactly(currentArtifactFile)) {
            contains = true;
            log.debug("Artifact {} already unpacked", (Object)artifact);
        }
        return contains;
    }

    private String artifactToString(Artifact artifact) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        return String.format("G:%s - A:%s - C:%s", groupId, artifactId, classifier);
    }

    private boolean classifierMatchesConfig(String classifier) {
        if (classifier == null) {
            return false;
        }
        boolean prefixMatches = classifier != null && classifier.startsWith(NATIVES_PREFIX);
        log.debug("prefixMatches={}", (Object)prefixMatches);
        String suffix = classifier.replace(NATIVES_PREFIX, "");
        log.debug("suffix = {}", (Object)suffix);
        boolean suffixMatchesCurrentOs = false;
        for (OsFilter filter : this.osFilters) {
            if (!filter.accepts(suffix)) continue;
            suffixMatchesCurrentOs = true;
            break;
        }
        boolean matches = prefixMatches && suffixMatchesCurrentOs;
        return matches;
    }

    private File computeUnpackingDir(String classifier) {
        File artifactDir;
        if (this.separateDirs) {
            String suffix = classifier.substring(NATIVES_PREFIX.length());
            artifactDir = new File(this.nativesTargetDir, suffix);
        } else {
            artifactDir = this.nativesTargetDir;
        }
        artifactDir.mkdirs();
        return artifactDir;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setNativesTargetDir(File nativesTargetDir) {
        this.nativesTargetDir = nativesTargetDir;
    }

    public void setSeparateDirs(boolean separateDirs) {
        this.separateDirs = separateDirs;
    }

    public void setAutoDetectOSNatives(boolean autoDetectOSNatives) {
        this.autoDetectOSNatives = autoDetectOSNatives;
    }

    public void setAutoDetectDirUpInFilesystem(boolean autoDetectDirUpInFilesystem) {
        this.autoDetectDirUpInFilesystem = autoDetectDirUpInFilesystem;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setOsFilters(List<OsFilter> osFilters) {
        this.osFilters = osFilters;
    }

    public void setArtifactHandler(IArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    static {
        jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        jsonMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

