/*
 * Decompiled with CFR 0.152.
 */
package com.teamtter.mavennatives.nativedependencies;

import java.beans.ConstructorProperties;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsFilter {
    private static final Logger log = LoggerFactory.getLogger(OsFilter.class);
    static final String OS = System.getProperty("os.name").toLowerCase();
    static final String OS_ARCH = System.getProperty("os.arch").toLowerCase();
    private String osName;
    private String osArch;
    private String suffix;

    public OsFilter() {
    }

    public boolean accepts(String effectiveSuffix) {
        effectiveSuffix = effectiveSuffix.toLowerCase();
        this.osName = this.osName != null ? this.osName.toLowerCase() : "";
        this.osArch = this.osArch != null ? this.osArch.toLowerCase() : "";
        this.suffix = this.suffix != null ? this.suffix.toLowerCase() : "";
        boolean filterMatches = false;
        if (StringUtils.isNotBlank((String)this.osName) && OS.contains(this.osName) && (StringUtils.isBlank((String)this.osArch) || this.filterToOsArchMatches())) {
            filterMatches = effectiveSuffix.contains(this.suffix);
        }
        log.debug(this.toString() + " accepts suffix '" + effectiveSuffix + "': " + filterMatches);
        return filterMatches;
    }

    private boolean filterToOsArchMatches() {
        return StringUtils.isNotBlank((String)this.osArch) && OS_ARCH.contains(this.osArch);
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OsFilter)) {
            return false;
        }
        OsFilter other = (OsFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        String this$osArch = this.getOsArch();
        String other$osArch = other.getOsArch();
        if (this$osArch == null ? other$osArch != null : !this$osArch.equals(other$osArch)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OsFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        String $osArch = this.getOsArch();
        result = result * 59 + ($osArch == null ? 43 : $osArch.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        return result;
    }

    public String toString() {
        return "OsFilter(osName=" + this.getOsName() + ", osArch=" + this.getOsArch() + ", suffix=" + this.getSuffix() + ")";
    }

    @ConstructorProperties(value={"osName", "osArch", "suffix"})
    public OsFilter(String osName, String osArch, String suffix) {
        this.osName = osName;
        this.osArch = osArch;
        this.suffix = suffix;
    }
}

