/*
 * Decompiled with CFR 0.152.
 */
package com.teamtter.mavennatives.nativedependencies;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class UnpackedArtifactsInfo {
    private Map<String, Long> pathToLastModified = new HashMap<String, Long>();

    public void flagAsUnpacked(File file) {
        Path normalizedPath = file.toPath().normalize();
        String pathAsString = normalizedPath.toString();
        long lastModified = file.lastModified();
        this.pathToLastModified.put(pathAsString, lastModified);
    }

    public boolean containsExactly(File currentArtifactFile) {
        long currentArtifactLastModifiedDate;
        boolean contains = false;
        String normalizedPath = currentArtifactFile.toPath().normalize().toString();
        Long lastModifiedDate = this.pathToLastModified.get(normalizedPath);
        if (lastModifiedDate != null && (currentArtifactLastModifiedDate = currentArtifactFile.lastModified()) == lastModifiedDate) {
            contains = true;
        }
        return contains;
    }

    public Map<String, Long> getPathToLastModified() {
        return this.pathToLastModified;
    }

    public void setPathToLastModified(Map<String, Long> pathToLastModified) {
        this.pathToLastModified = pathToLastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnpackedArtifactsInfo)) {
            return false;
        }
        UnpackedArtifactsInfo other = (UnpackedArtifactsInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Long> this$pathToLastModified = this.getPathToLastModified();
        Map<String, Long> other$pathToLastModified = other.getPathToLastModified();
        return !(this$pathToLastModified == null ? other$pathToLastModified != null : !((Object)this$pathToLastModified).equals(other$pathToLastModified));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnpackedArtifactsInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Long> $pathToLastModified = this.getPathToLastModified();
        result = result * 59 + ($pathToLastModified == null ? 43 : ((Object)$pathToLastModified).hashCode());
        return result;
    }

    public String toString() {
        return "UnpackedArtifactsInfo(pathToLastModified=" + this.getPathToLastModified() + ")";
    }
}

