/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data.jdbc;

import com.techempower.TechEmpowerApplication;
import com.techempower.asynchronous.Asynchronous;
import com.techempower.data.ConnectionMonitor;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseAffinity;
import com.techempower.helper.StringHelper;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiConnectorFactory
implements ConnectorFactory,
Configurable,
Asynchronous {
    public static final String DEFAULT_PROPERTY_PREFIX = "db.Jndi.";
    private final String propertyPrefix;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private DataSource dataSource;
    private boolean enabled = true;
    private String identifierQuoteString = " ";
    private DatabaseAffinity databaseAffinity;

    public JndiConnectorFactory(String propertyPrefix) {
        this.propertyPrefix = StringHelper.isNonEmpty((String)propertyPrefix) ? propertyPrefix : DEFAULT_PROPERTY_PREFIX;
    }

    @Deprecated(forRemoval=true)
    public JndiConnectorFactory(TechEmpowerApplication application, String propertyPrefix) {
        this(propertyPrefix);
    }

    public void configure(EnhancedProperties rawProps) {
        EnhancedProperties.Focus props = rawProps.focus(this.propertyPrefix);
        this.enabled = props.getBoolean("Enabled", true);
        String jndiName = props.get("Name", "java:comp/env/jdbc/database");
        this.log.debug("JNDI name to be fetched: {}", (Object)jndiName);
        if (this.enabled) {
            this.end();
            try {
                InitialContext ic = new InitialContext();
                this.dataSource = (DataSource)ic.lookup(jndiName);
            }
            catch (NamingException e) {
                this.log.debug("Unable to fetch JNDI data source for name {}", (Object)jndiName, (Object)e);
            }
            try {
                this.dataSource.setLogWriter(new PrintWriter(System.out));
            }
            catch (SQLException e) {
                this.log.debug("Unable to set log writer", (Throwable)e);
            }
            this.determineIdentifierQuoteString();
            this.determineDatabaseAffinity();
        } else {
            this.log.info("Database connector factory disabled.");
        }
    }

    public void determineIdentifierQuoteString() {
        this.log.debug("Determining identifier quote string from database.");
        try (ConnectionMonitor monitor = this.getConnectionMonitor();){
            this.identifierQuoteString = monitor.getConnection().getMetaData().getIdentifierQuoteString();
        }
        catch (Exception e) {
            this.log.debug("Exception while reading identifier quote string.", (Throwable)e);
        }
        this.log.debug("Identifier quote string: {}", (Object)this.identifierQuoteString);
    }

    public void begin() {
    }

    public void end() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ConnectionMonitor getConnectionMonitor() throws SQLException {
        return new Monitor(this.dataSource.getConnection());
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public DatabaseAffinity getDatabaseAffinity() {
        return this.databaseAffinity;
    }

    public void determineDatabaseAffinity() {
        this.log.debug("Determining DatabaseAffinity.");
        String dbProductName = null;
        try (ConnectionMonitor monitor = this.getConnectionMonitor();){
            dbProductName = this.identifierQuoteString = monitor.getConnection().getMetaData().getDatabaseProductName();
            this.databaseAffinity = DatabaseAffinity.getAffinityFromName((String)dbProductName);
        }
        catch (Exception e) {
            this.log.debug("Exception while determining database affinity.", (Throwable)e);
        }
        this.log.debug("DatabaseAffinity: {} from database product name {}", (Object)this.databaseAffinity, (Object)dbProductName);
    }

    private static class Monitor
    implements ConnectionMonitor {
        private Connection connection;

        public Monitor(Connection c) {
            this.connection = c;
        }

        public Connection getConnection() throws SQLException {
            return this.connection;
        }

        public void close() throws SQLException {
            this.connection.close();
        }

        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException();
        }

        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        public Connection getConnection(String username, String password) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        public PrintWriter getLogWriter() throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        public int getLoginTimeout() throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }
    }
}

