/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.jungle;

import com.google.common.base.Preconditions;
import com.techshroom.jungle.ConfigOption;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class ConfigOptionBase<T>
implements ConfigOption<T> {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final T defaultValue;
    private T value;

    protected ConfigOptionBase(T defaultValue) {
        Preconditions.checkArgument((defaultValue != null ? 1 : 0) != 0, (Object)"Null defaultValue");
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public T getDefault() {
        this.lock.readLock().lock();
        try {
            T t = this.defaultValue;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T get() {
        this.lock.readLock().lock();
        try {
            T t = this.value;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void set(T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Null value");
        this.lock.writeLock().lock();
        try {
            this.value = value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

