/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.jungle;

import com.google.common.base.Preconditions;
import com.techshroom.jungle.EnvConfigOption;
import com.techshroom.jungle.LoadingConfigOption;
import com.techshroom.jungle.ValueAccess;
import java.util.Optional;
import java.util.function.Function;

public class EnvConfigOptionBase<T>
extends LoadingConfigOption<T>
implements EnvConfigOption<T> {
    private final String environmentVariableName;
    private final Function<String, Optional<T>> loader;

    protected EnvConfigOptionBase(String environmentVariableName, Function<String, Optional<T>> loader, T defaultValue) {
        super(defaultValue);
        Preconditions.checkArgument((environmentVariableName != null ? 1 : 0) != 0, (Object)"Null name");
        Preconditions.checkArgument((loader != null ? 1 : 0) != 0, (Object)"Null loader");
        this.environmentVariableName = environmentVariableName;
        this.loader = loader;
    }

    @Override
    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    @Override
    protected Optional<T> load() {
        return ValueAccess.getEnv(this.environmentVariableName).flatMap(this.loader);
    }
}

