/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.jungle;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Loaders {
    private static final Function<String, Optional<Integer>> INT = text -> {
        try {
            return Optional.of(Integer.parseInt(text));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    };
    private static final Function<String, Optional<Long>> LONG = text -> {
        try {
            return Optional.of(Long.parseLong(text));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    };
    private static final Function<String, Optional<Double>> DOUBLE = text -> {
        try {
            return Optional.of(Double.parseDouble(text));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    };
    private static final ImmutableSet<String> YES = (ImmutableSet)Stream.of("y", "yes", "1").collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)String.CASE_INSENSITIVE_ORDER));
    private static final Function<String, Optional<Boolean>> BOOLEAN = text -> {
        boolean result = Boolean.parseBoolean(text) || YES.contains(text);
        return Optional.of(result);
    };
    private static final Function<String, Optional<String>> STRING = Optional::of;

    public static Function<String, Optional<Integer>> forInt() {
        return INT;
    }

    public static Function<String, Optional<Integer>> forIntInRange(int min, int max) {
        return Loaders.forInt().andThen(o -> o.filter(i -> min <= i && i < max));
    }

    public static Function<String, Optional<Long>> forLong() {
        return LONG;
    }

    public static Function<String, Optional<Long>> forLongInRange(long min, long max) {
        return Loaders.forLong().andThen(o -> o.filter(l -> min <= l && l < max));
    }

    public static Function<String, Optional<Double>> forDouble() {
        return DOUBLE;
    }

    public static Function<String, Optional<Double>> forDoubleInRange(double min, double max) {
        return Loaders.forDouble().andThen(o -> o.filter(d -> min <= d && d < max));
    }

    public static Function<String, Optional<Boolean>> forBoolean() {
        return BOOLEAN;
    }

    public static Function<String, Optional<String>> forString() {
        return STRING;
    }

    public static Function<String, Optional<String>> forStringMatching(Predicate<String> test) {
        return STRING.andThen(o -> o.filter(test));
    }

    private Loaders() {
        throw new AssertionError();
    }
}

