/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.jungle;

import com.techshroom.jungle.ConfigOptionBase;
import java.util.Optional;

public abstract class LoadingConfigOption<T>
extends ConfigOptionBase<T> {
    private boolean set;

    protected LoadingConfigOption(T defaultValue) {
        super(defaultValue);
    }

    @Override
    public T get() {
        this.loadIfNeeded();
        return super.get();
    }

    @Override
    public void set(T value) {
        this.lock.writeLock().lock();
        try {
            super.set(value);
            this.set = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void loadIfNeeded() {
        if (!this.set) {
            this.lock.writeLock().lock();
            try {
                if (!this.set) {
                    this.set(this.load().orElse(this.getDefault()));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected abstract Optional<T> load();
}

