/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.jungle;

import com.google.common.base.Preconditions;
import com.techshroom.jungle.LoadingConfigOption;
import com.techshroom.jungle.PropOrEnvConfigOption;
import com.techshroom.jungle.ValueAccess;
import java.util.Optional;
import java.util.function.Function;

public class PropOrEnvConfigOptionBase<T>
extends LoadingConfigOption<T>
implements PropOrEnvConfigOption<T> {
    private final String environmentVariableName;
    private final String systemPropertyName;
    private final Function<String, Optional<T>> loader;

    protected PropOrEnvConfigOptionBase(String environmentVariableName, String systemPropertyName, Function<String, Optional<T>> loader, T defaultValue) {
        super(defaultValue);
        Preconditions.checkArgument((environmentVariableName != null ? 1 : 0) != 0, (Object)"Null environment name");
        Preconditions.checkArgument((systemPropertyName != null ? 1 : 0) != 0, (Object)"Null property name");
        Preconditions.checkArgument((loader != null ? 1 : 0) != 0, (Object)"Null loader");
        this.environmentVariableName = environmentVariableName;
        this.systemPropertyName = systemPropertyName;
        this.loader = loader;
    }

    @Override
    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    @Override
    public String getSystemPropertyName() {
        return this.systemPropertyName;
    }

    @Override
    protected Optional<T> load() {
        Optional<String> env = ValueAccess.getEnv(this.environmentVariableName);
        Optional<String> prop = ValueAccess.getProp(this.systemPropertyName);
        return (prop.isPresent() ? prop : env).flatMap(this.loader);
    }
}

