/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.jungle;

import com.techshroom.jungle.NamespaceBase;
import com.techshroom.jungle.PropOrEnvConfigOption;
import java.util.Optional;
import java.util.function.Function;

public class PropOrEnvNamespace
extends NamespaceBase {
    private final String envName;
    private final String propName;

    public static PropOrEnvNamespace create(String name) {
        return new PropOrEnvNamespace(name.toUpperCase(), name);
    }

    private PropOrEnvNamespace(String envName, String propName) {
        super(propName);
        this.envName = envName;
        this.propName = propName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public String getPropName() {
        return this.propName;
    }

    @Override
    public PropOrEnvNamespace subspace(String name) {
        return new PropOrEnvNamespace(this.envName(name), this.propName(name));
    }

    private String envName(String name) {
        return this.envName.toUpperCase() + "_" + name.toUpperCase();
    }

    private String propName(String name) {
        return this.propName + "." + name;
    }

    public <T> PropOrEnvConfigOption<T> create(String name, Function<String, Optional<T>> loader, T defaultValue) {
        return PropOrEnvConfigOption.create(this.envName(name), this.propName(name), loader, defaultValue);
    }
}

