/*
 * Decompiled with CFR 0.152.
 */
package com.techshroom.jungle;

import com.google.common.base.Preconditions;
import com.techshroom.jungle.LoadingConfigOption;
import com.techshroom.jungle.SysPropConfigOption;
import com.techshroom.jungle.ValueAccess;
import java.util.Optional;
import java.util.function.Function;

public class SysPropConfigOptionBase<T>
extends LoadingConfigOption<T>
implements SysPropConfigOption<T> {
    private final String systemPropertyName;
    private final Function<String, Optional<T>> loader;

    protected SysPropConfigOptionBase(String systemPropertyName, Function<String, Optional<T>> loader, T defaultValue) {
        super(defaultValue);
        Preconditions.checkArgument((systemPropertyName != null ? 1 : 0) != 0, (Object)"Null name");
        Preconditions.checkArgument((loader != null ? 1 : 0) != 0, (Object)"Null loader");
        this.systemPropertyName = systemPropertyName;
        this.loader = loader;
    }

    @Override
    public String getSystemPropertyName() {
        return this.systemPropertyName;
    }

    @Override
    protected Optional<T> load() {
        return ValueAccess.getProp(this.systemPropertyName).flatMap(this.loader);
    }
}

