/*
 * Decompiled with CFR 0.152.
 */
package com.techyourchance.threadposter.testdoubles;

import com.techyourchance.threadposter.BackgroundThreadPoster;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class BackgroundThreadPosterTestDouble
extends BackgroundThreadPoster {
    private final Object MONITOR = new Object();
    private final Queue<Runnable> mRunnables = new ConcurrentLinkedQueue<Runnable>();
    private int mNonCompletedRunnables = 0;

    BackgroundThreadPosterTestDouble() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(Runnable runnable) {
        Object object = this.MONITOR;
        synchronized (object) {
            this.mRunnables.add(runnable);
            ++this.mNonCompletedRunnables;
            this.MONITOR.notifyAll();
        }
    }

    @Override
    protected ThreadPoolExecutor newThreadPoolExecutor() {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable r) {
                return new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        r.run();
                        Object object = BackgroundThreadPosterTestDouble.this.MONITOR;
                        synchronized (object) {
                            BackgroundThreadPosterTestDouble.this.mNonCompletedRunnables--;
                            BackgroundThreadPosterTestDouble.this.MONITOR.notifyAll();
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void join() {
        Object object = this.MONITOR;
        synchronized (object) {
            while (this.mNonCompletedRunnables > 0) {
                Runnable runnable;
                while ((runnable = this.mRunnables.poll()) != null) {
                    super.post(runnable);
                }
                try {
                    this.MONITOR.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("interrupted");
                }
            }
        }
    }
}

