/*
 * Decompiled with CFR 0.152.
 */
package com.teketik.test.mockinbean;

import java.lang.reflect.Field;
import java.util.Map;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

abstract class BeanUtils {
    private BeanUtils() {
    }

    static <T> T findBean(Class<T> type, @Nullable String name, ApplicationContext applicationContext) {
        Object beanOrProxy;
        Map beansOfType = applicationContext.getBeansOfType(type);
        Assert.isTrue((!beansOfType.isEmpty() ? 1 : 0) != 0, () -> "No beans of type " + type);
        if (beansOfType.size() == 1) {
            beanOrProxy = beansOfType.values().iterator().next();
        } else {
            Assert.notNull((Object)name, () -> "Multiple beans of type " + type + ". A name must be provided");
            beanOrProxy = beansOfType.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(name)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("No beans of type " + type + " and name " + name));
        }
        return (T)(AopUtils.isAopProxy(beanOrProxy) ? AopProxyUtils.getSingletonTarget(beanOrProxy) : beanOrProxy);
    }

    static Field findField(Class<?> clazz, @Nullable String name, Class<?> type) {
        Object[] results = new Object[2];
        ReflectionUtils.doWithFields(clazz, field -> {
            if (name != null && field.getName().equalsIgnoreCase(name)) {
                results[0] = results[0] == null ? field : Boolean.FALSE;
            }
            results[1] = results[1] == null ? field : Boolean.FALSE;
        }, field -> field.getType().isAssignableFrom(type));
        if (results[0] != null) {
            Assert.isTrue((!(results[0] instanceof Boolean) ? 1 : 0) != 0, () -> "Multiple fields of type " + type + " in " + clazz + " with name " + name);
            return (Field)results[0];
        }
        if (results[1] != null) {
            Assert.isTrue((!(results[1] instanceof Boolean) ? 1 : 0) != 0, () -> "Multiple fields of type " + type + " in " + clazz + (name != null ? " and none with name " + name : ". Please specify a name."));
            return (Field)results[1];
        }
        return null;
    }

    @Nullable
    static TargetSource getProxyTarget(Object candidate) {
        try {
            while (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised) {
                Advised advised = (Advised)candidate;
                TargetSource targetSource = advised.getTargetSource();
                if (targetSource.isStatic()) {
                    Object target = targetSource.getTarget();
                    if (target == null || !AopUtils.isAopProxy((Object)target)) {
                        return targetSource;
                    }
                    candidate = target;
                    continue;
                }
                return null;
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return null;
    }
}

