/*
 * Decompiled with CFR 0.152.
 */
package com.teketik.test.mockinbean;

import com.teketik.test.mockinbean.Definition;
import com.teketik.test.mockinbean.InBeanDefinition;
import com.teketik.test.mockinbean.MockDefinition;
import com.teketik.test.mockinbean.MockInBean;
import com.teketik.test.mockinbean.SpyDefinition;
import com.teketik.test.mockinbean.SpyInBean;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class InBeanDefinitionsParser {
    private final Map<Definition, List<InBeanDefinition>> definitions = new HashMap<Definition, List<InBeanDefinition>>();

    InBeanDefinitionsParser() {
    }

    void parse(Class<?> source) {
        ReflectionUtils.doWithFields(source, field -> this.parseField(field, source));
    }

    private void parseField(Field element, Class<?> source) {
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS);
        annotations.stream(MockInBean.class).map(MergedAnnotation::synthesize).forEach(annotation -> this.parseMockInBeanAnnotation((MockInBean)annotation, element, source));
        annotations.stream(SpyInBean.class).map(MergedAnnotation::synthesize).forEach(annotation -> this.parseSpyInBeanAnnotation((SpyInBean)annotation, element, source));
    }

    private void parseMockInBeanAnnotation(MockInBean annotation, Field field, Class<?> source) {
        Set<ResolvableType> typesToMock = this.getOrDeduceTypes(field, source);
        Assert.state((!typesToMock.isEmpty() ? 1 : 0) != 0, () -> "Unable to deduce type to mock from " + field);
        for (ResolvableType typeToMock : typesToMock) {
            MockDefinition definition = new MockDefinition(field.getName(), typeToMock);
            InBeanDefinition inBeanDefinition = new InBeanDefinition(annotation.value(), StringUtils.isEmpty((Object)annotation.name()) ? null : annotation.name());
            this.addDefinition(definition, inBeanDefinition);
        }
    }

    private void parseSpyInBeanAnnotation(SpyInBean annotation, Field field, Class<?> source) {
        Set<ResolvableType> typesToSpy = this.getOrDeduceTypes(field, source);
        Assert.state((!typesToSpy.isEmpty() ? 1 : 0) != 0, () -> "Unable to deduce type to spy from " + field);
        for (ResolvableType typeToSpy : typesToSpy) {
            SpyDefinition definition = new SpyDefinition(field.getName(), typeToSpy);
            InBeanDefinition inBeanDefinition = new InBeanDefinition(annotation.value(), StringUtils.isEmpty((Object)annotation.name()) ? null : annotation.name());
            this.addDefinition(definition, inBeanDefinition);
        }
    }

    private void addDefinition(Definition definition, InBeanDefinition inBeanDefinition) {
        List<InBeanDefinition> inBeanBaseDefinitions = this.definitions.get(definition);
        if (inBeanBaseDefinitions == null) {
            inBeanBaseDefinitions = new LinkedList<InBeanDefinition>();
            this.definitions.put(definition, inBeanBaseDefinitions);
        }
        inBeanBaseDefinitions.add(inBeanDefinition);
    }

    private Set<ResolvableType> getOrDeduceTypes(AnnotatedElement element, Class<?> source) {
        LinkedHashSet<ResolvableType> types = new LinkedHashSet<ResolvableType>();
        if (types.isEmpty() && element instanceof Field) {
            Field field = (Field)element;
            types.add(field.getGenericType() instanceof TypeVariable ? ResolvableType.forField((Field)field, source) : ResolvableType.forField((Field)field));
        }
        return types;
    }

    public Map<Definition, List<InBeanDefinition>> getDefinitions() {
        return Collections.unmodifiableMap(this.definitions);
    }
}

