/*
 * Decompiled with CFR 0.152.
 */
package com.teketik.test.mockinbean;

import com.teketik.test.mockinbean.BeanFieldState;
import com.teketik.test.mockinbean.BeanUtils;
import com.teketik.test.mockinbean.Definition;
import com.teketik.test.mockinbean.FieldState;
import com.teketik.test.mockinbean.InBeanDefinition;
import com.teketik.test.mockinbean.InBeanDefinitionsParser;
import com.teketik.test.mockinbean.ProxiedBeanFieldState;
import com.teketik.test.mockinbean.SpyDefinition;
import com.teketik.test.mockinbean.TestFieldState;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.Nested;
import org.springframework.aop.TargetSource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class MockInBeanTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String ORIGINAL_VALUES_ATTRIBUTE_NAME = "MockInBean.originalValues";
    private static final Map<Class<?>, TestContext> ROOT_TEST_CONTEXT_TRACKER = new ConcurrentHashMap(new HashMap());

    MockInBeanTestExecutionListener() {
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        if (this.isNestedTestClass(testContext.getTestClass())) {
            return;
        }
        ROOT_TEST_CONTEXT_TRACKER.put(testContext.getTestClass(), testContext);
        InBeanDefinitionsParser parser = new InBeanDefinitionsParser();
        Class<?> targetTestClass = this.resolveTestClass(testContext.getTestClass());
        parser.parse(targetTestClass);
        HashSet<Field> visitedFields = new HashSet<Field>();
        LinkedList<FieldState> originalValues = new LinkedList<FieldState>();
        for (Map.Entry<Definition, List<InBeanDefinition>> definitionToInbeans : parser.getDefinitions().entrySet()) {
            Definition definition = definitionToInbeans.getKey();
            Class<?> mockOrSpyType = this.extractClass(definition);
            Field beanField = null;
            for (InBeanDefinition inBeanDefinition : definitionToInbeans.getValue()) {
                Object inBean = BeanUtils.findBean(inBeanDefinition.clazz, inBeanDefinition.name, testContext.getApplicationContext());
                beanField = BeanUtils.findField(inBean.getClass(), definition.getName(), mockOrSpyType);
                Assert.notNull((Object)beanField, (String)("Cannot find any field for definition:" + definitionToInbeans.getKey()));
                beanField.setAccessible(true);
                Object beanFieldValue = ReflectionUtils.getField((Field)beanField, inBean);
                TargetSource proxyTarget = BeanUtils.getProxyTarget(beanFieldValue);
                BeanFieldState beanFieldState = proxyTarget != null ? new ProxiedBeanFieldState(inBean, beanField, beanFieldValue, proxyTarget, definition) : new BeanFieldState(inBean, beanField, beanFieldValue, definition);
                originalValues.add(beanFieldState);
            }
            Assert.isTrue((boolean)visitedFields.add(beanField), (String)(beanField + " can only be mapped once, as a mock or a spy, not both!"));
            Field testField = ReflectionUtils.findField(targetTestClass, (String)definition.getName(), mockOrSpyType);
            testField.setAccessible(true);
            originalValues.add(new TestFieldState(testField, definition));
        }
        testContext.setAttribute(ORIGINAL_VALUES_ATTRIBUTE_NAME, originalValues);
        super.beforeTestClass(testContext);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        TestContext applicableTestContext = ROOT_TEST_CONTEXT_TRACKER.get(this.resolveTestClass(testContext.getTestClass()));
        HashMap mockOrSpys = new HashMap();
        LinkedList fieldStates = (LinkedList)applicableTestContext.getAttribute(ORIGINAL_VALUES_ATTRIBUTE_NAME);
        IdentityHashMap spyTracker = new IdentityHashMap();
        fieldStates.stream().filter(BeanFieldState.class::isInstance).map(BeanFieldState.class::cast).forEach(fieldState -> {
            Object mockOrSpy = mockOrSpys.get(fieldState.definition);
            if (mockOrSpy == null) {
                mockOrSpy = fieldState.createMockOrSpy();
                mockOrSpys.put(fieldState.definition, mockOrSpy);
                if (fieldState.definition instanceof SpyDefinition) {
                    spyTracker.put(fieldState.originalValue, mockOrSpy);
                }
            }
        });
        fieldStates.forEach(fieldState -> {
            Object mockOrSpy = mockOrSpys.get(fieldState.definition);
            Object bean = fieldState.resolveTarget(applicableTestContext);
            this.inject(fieldState.field, bean, mockOrSpy);
            Optional.ofNullable(spyTracker.get(bean)).ifPresent(spy -> this.inject(fieldState.field, spy, mockOrSpy));
        });
        super.beforeTestMethod(testContext);
    }

    private void inject(Field field, Object inObject, Object toInject) {
        ReflectionUtils.setField((Field)field, (Object)inObject, (Object)toInject);
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        if (this.isNestedTestClass(testContext.getTestClass())) {
            return;
        }
        ((LinkedList)testContext.getAttribute(ORIGINAL_VALUES_ATTRIBUTE_NAME)).stream().filter(BeanFieldState.class::isInstance).map(BeanFieldState.class::cast).forEach(fieldState -> fieldState.rollback(testContext));
        ROOT_TEST_CONTEXT_TRACKER.remove(testContext.getTestClass());
        super.afterTestClass(testContext);
    }

    private Class<?> extractClass(Definition definition) {
        Type type = definition.getResolvableType().getType();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private Class<?> resolveTestClass(Class<?> candidate) {
        if (this.isNestedTestClass(candidate)) {
            return this.resolveTestClass(candidate.getEnclosingClass());
        }
        return candidate;
    }

    private boolean isNestedTestClass(Class<?> candidate) {
        return AnnotationUtils.isAnnotationDeclaredLocally(Nested.class, candidate) && candidate.getEnclosingClass() != null;
    }
}

